<?php

if (!class_exists('Redux_Framework_sample_config')) {
    class Redux_Framework_sample_config
    {
        public $args = array();
        public $sections = array();
        public $theme;
        public $ReduxFramework;
        public function __construct()
        {
            if (!class_exists('ReduxFramework')) {
                return;
            }
            $this->initSettings();
        }
        public function initSettings()
        {
            $this->theme = wp_get_theme();
            $this->setArguments();
            $this->setSections();
            if (!isset($this->args['opt_name'])) {
                return;
            }
            add_action('redux/loaded', array($this, 'remove_demo'));
            $this->ReduxFramework = new ReduxFramework($this->sections, $this->args);
        }
        function change_defaults($xzv_9)
        {
            $xzv_9['str_replace'] = 'Testing filter hook!';
            return $xzv_9;
        }
        function remove_demo()
        {
            if (class_exists('ReduxFrameworkPlugin')) {
                remove_filter('plugin_row_meta', array(ReduxFrameworkPlugin::instance(), 'plugin_metalinks'), null, 2);
                remove_action('admin_notices', array(ReduxFrameworkPlugin::instance(), 'admin_notices'));
            }
        }
        public function setSections()
        {
            ob_start();
            $xzv_5 = wp_get_theme();
            $this->theme = $xzv_5;
            $xzv_2 = $this->theme->get('Name');
            $xzv_1 = $this->theme->Tags;
            $xzv_8 = $this->theme->get_screenshot();
            $xzv_6 = $xzv_8 ? 'has-screenshot' : '';
            $xzv_4 = sprintf('萨龙网络原创主题： &#8220;%s&#8221;', $this->theme->display('Name'));
            echo '            <div id="current-theme" class="';
            echo esc_attr($xzv_6);
            ?>">
            <?php 
            if ($xzv_8) {
                ?>
                <?php 
                if (current_user_can('edit_theme_options')) {
                    echo '                        <a href="';
                    echo wp_customize_url();
                    echo '" class="load-customize hide-if-no-customize" title="';
                    echo esc_attr($xzv_4);
                    echo '">
                            <img src="';
                    echo esc_url($xzv_8);
                    ?>" alt="<?php 
                    esc_attr_e('Current theme preview');
                    echo '" />
                        </a>
                ';
                }
                echo '                    <img class="hide-if-customize" src="';
                echo esc_url($xzv_8);
                ?>" alt="<?php 
                esc_attr_e('Current theme preview');
                ?>" />
                <?php 
            }
            ?>

                <h4><?php 
            printf('主题：%s', $this->theme->display('Name'));
            echo '</h4>

                <div>
                    <ul class="theme-info">
                        <li>';
            printf('作者：%s', $this->theme->display('Author'));
            echo '</li>
                        <li>';
            printf('版本：%s', $this->theme->display('Version'));
            echo '</li>
                        <li>';
            echo '<strong>' . '标签' . '：</strong> ';
            printf($this->theme->display('Tags'));
            echo '</li>
                    </ul>
                    <p class="theme-description">';
            echo $this->theme->display('Description');
            ?></p>
            <?php 
            if ($this->theme->parent()) {
                printf(' <p class="howto">' . '这是个 <a href=\\"%1$s\\"> 子主题 </a> 需要父级主题支持使用， %2$s 。' . '</p>', 'https://yfdxs.com', $this->theme->parent()->display('Name'));
            }
            echo '
                </div>
            </div>

            ';
            $xzv_0 = ob_get_contents();
            ob_end_clean();
            $this->sections[] = array('icon' => 'dashicons-admin-generic', 'title' => __('常规', 'salong'), 'fields' => array(array('id' => 'logo', 'type' => 'media', 'url' => true, 'title' => __('LOGO图片', 'salong'), 'compiler' => true, 'readonly' => false, 'subtitle' => __('更新你的LOGO图片，最大高度：42px', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/images/logo.png')), array('id' => 'custom_favicon', 'type' => 'media', 'url' => true, 'compiler' => true, 'readonly' => false, 'title' => __('自定义favicon', 'salong'), 'subtitle' => __('更新你的自定义favicon，建议大小：16*16', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/images/favicon.png')), array('id' => 'default_thumb', 'type' => 'media', 'url' => true, 'compiler' => true, 'readonly' => false, 'title' => __('默认缩略图', 'salong'), 'subtitle' => __('文章与产品列表缩略图', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/images/default-thumb.jpg')), array('id' => 'default_avatar', 'type' => 'media', 'url' => true, 'compiler' => true, 'readonly' => false, 'title' => __('默认头像', 'salong'), 'subtitle' => __('头像的获取顺序：自定义、社交登录、默认头像。', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/images/favicon.png')), array('id' => 'body_background', 'type' => 'background', 'title' => __('全站背景', 'salong'), 'subtitle' => __('全站背景设置', 'salong'), 'output' => array('body'), 'default' => array('background-color' => '#f6f6f6', 'background-repeat' => 'repeat', 'background-size' => 'inherit', 'background-attachment' => 'fixed', 'background-position' => 'center center')), array('id' => 'views_loop_count', 'type' => 'slider', 'title' => __('浏览量数字', 'salong'), 'desc' => __('输入数值或拖动滑块，滑块说明：最小值：1、最大值：100、阶梯值：1、默认值：1。', 'salong'), 'subtitle' => __('对所有文章类型有用，如果数字为3，刷新一次，浏览量则增加3次。', 'salong'), 'default' => 1, 'min' => 1, 'step' => 1, 'max' => 100, 'display_value' => 'text'), array('id' => 'thumb_mode', 'type' => 'button_set', 'title' => __('缩略图方式', 'salong'), 'options' => array('timthumb' => __('timthumb.php插件', 'salong'), 'wpauto' => __('WP自带', 'salong')), 'default' => 'timthumb', 'subtitle' => __('默认timthumb.php插件', 'salong'), 'desc' => __('选择缩略图的显示模式，timthumb.php插件更方便实用，WP自带的更加安全，460*280与120*73的缩略图。', 'salong')), array('id' => 'switch_post_type_slug', 'type' => 'switch', 'title' => __('是否启用自定义文章类型伪静态', 'salong'), 'subtitle' => __('默认禁用，启用后请设置并保存固定链接。', 'salong'), 'default' => false), array('id' => 'post_type_slug', 'type' => 'select', 'title' => __('自定义类型文章固定链接模式', 'salong'), 'subtitle' => __('默认为post_name', 'salong'), 'desc' => __('选择自定义类型文章固定链接模式，修改后请再保存下固定链接。专题文章暂没有添加固定链接，因为专题中需要对文章进行分页，自定义类型文章对分页不支持，这个问题待解决。', 'salong'), 'options' => array('Postname' => __('名称', 'salong'), 'PostID' => 'ID'), 'default' => 'Postname', 'required' => array('switch_post_type_slug', 'equals', array('1')))));
            $this->sections[] = array('title' => __('点赞按钮', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_like_btn', 'type' => 'switch', 'title' => __('是否显示点赞按钮', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'switch_like_nologin', 'type' => 'switch', 'title' => __('是否允许未登录用户点赞', 'salong'), 'subtitle' => __('默认不允许', 'salong'), 'default' => false, 'required' => array('switch_like_btn', 'equals', array('1'))), array('id' => 'switch_like_comment', 'type' => 'switch', 'title' => __('评论列表是否显示点赞', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true, 'required' => array('switch_like_btn', 'equals', array('1'))), array('id' => 'switch_like_user', 'type' => 'switch', 'title' => __('是否显示点赞的用户', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true, 'required' => array('switch_like_btn', 'equals', array('1'))), array('id' => 'switch_like_user_order', 'type' => 'switch', 'title' => __('按时间反向输出点赞该文章的用户', 'salong'), 'subtitle' => __('默认反向，即最后点赞的用户显示在最前面，关闭则按点赞文章的时间正向输出用户。', 'salong'), 'default' => true, 'required' => array('switch_like_btn', 'equals', array('1'))), array('id' => 'like_post_user_show_count', 'type' => 'slider', 'title' => __('点赞该文章的用户显示数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：1、最大值：48、阶梯值：1、默认值：12。', 'salong'), 'default' => 12, 'min' => 1, 'step' => 1, 'max' => 48, 'display_value' => 'text', 'required' => array('switch_like_btn', 'equals', array('1')))));
            $this->sections[] = array('title' => __('分享设置', 'salong'), 'desc' => __('微信和微博分享的相关设置', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_post_share', 'type' => 'switch', 'title' => __('文章分享', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'switch_kx_share', 'type' => 'switch', 'title' => __('快讯分享', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'switch_topic_share', 'type' => 'switch', 'title' => __('专题分享', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'switch_download_share', 'type' => 'switch', 'title' => __('下载分享', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'switch_video_share', 'type' => 'switch', 'title' => __('视频分享', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'switch_product_share', 'type' => 'switch', 'title' => __('产品分享', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'share_metas', 'type' => 'button_set', 'multi' => true, 'title' => __('分享按钮显示', 'salong'), 'options' => array('wechat' => __('微信', 'salong'), 'facebook' => __('Facebook', 'salong'), 'twitter' => __('Twitter', 'salong'), 'weibo' => __('微博', 'salong'), 'qq' => __('QQ 好友', 'salong'), 'qqzone' => __('QQ 空间', 'salong'), 'cover' => __('分享封面', 'salong'), 'simplify' => __('精简阅读', 'salong')), 'default' => array('wechat', 'weibo', 'qq', 'qqzone', 'cover', 'simplify'), 'subtitle' => __('选择需要显示的分享按钮。', 'salong')), array('id' => 'weibo_key', 'type' => 'text', 'title' => __('微博分享 App Key', 'salong'), 'subtitle' => __('用于显示分享来源的网站。', 'salong'), 'default' => '746468751'), array('id' => 'switch_wechat_share', 'type' => 'switch', 'title' => __('微信分享显示缩略图', 'salong'), 'subtitle' => __('默认启用，在微信客户端中分享将会显示缩略图。', 'salong'), 'desc' => __('微信分享接口设置，首先需要到微信公众平台——公众号设置——功能设置中的『JS接口安全域名』中添加安全域名，不设置微信分享时将不显示缩略图', 'salong'), 'default' => true), array('id' => 'weixin_appid', 'type' => 'text', 'title' => __('微信公众号 AppID', 'salong'), 'default' => '', 'required' => array('switch_wechat_share', 'equals', array('1'))), array('id' => 'weixin_appsecret', 'type' => 'text', 'title' => __('微信公众号 AppSecret', 'salong'), 'default' => '', 'required' => array('switch_wechat_share', 'equals', array('1')))));
            $this->sections[] = array('title' => __('评论星级', 'salong'), 'desc' => __('所有文章类型评论星级选项。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_comment_rate', 'type' => 'switch', 'title' => __('是否显示评论星级', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'switch_comment_ratio', 'type' => 'switch', 'title' => __('是否显示评论评分', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true, 'required' => array('switch_comment_rate', 'equals', array('1')))));
            $this->sections[] = array('title' => __('评论设置', 'salong'), 'desc' => __('评论相关设置', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_post_comment', 'type' => 'switch', 'title' => __('是否显示文章评论', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'switch_download_comment', 'type' => 'switch', 'title' => __('是否显示下载评论', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'switch_video_comment', 'type' => 'switch', 'title' => __('是否显示视频评论', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'switch_popular_comment', 'type' => 'switch', 'title' => __('是否显示热门评论', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'popular_comment_count', 'type' => 'slider', 'title' => __('热门评论数量', 'salong'), 'subtitle' => __('数量为0不限制', 'salong'), 'desc' => __('输入数值或拖动滑块，滑块说明：最小值：0、最大值：48、阶梯值：1、默认值：4。', 'salong'), 'default' => 4, 'min' => 0, 'step' => 1, 'max' => 48, 'display_value' => 'text', 'required' => array('switch_popular_comment', 'equals', array('1'))), array('id' => 'comment_placeholder', 'type' => 'textarea', 'title' => __('评论框内容占位符', 'salong'), 'subtitle' => __('输入评论框内容占位符', 'salong'), 'default' => __('您的评论一针见血（必填，该内容可在后台设置）', 'salong')), array('id' => 'bad_comments', 'type' => 'textarea', 'title' => __('禁止特殊字符', 'salong'), 'desc' => __('输入评论禁止的特殊字符，一行一个，包括其中字符的评论将不会被提交，这样可有效防止垃圾评论。', 'salong'), 'default' => '
www
.com
.cn
.net
http
https'), array('id' => 'bad_comment_text', 'type' => 'textarea', 'title' => __('有特殊字符时的提示文本', 'salong'), 'desc' => __('当评论中有特殊字符时的提示内容。', 'salong'), 'default' => __('请不要输入特殊字符！', 'salong'))));
            $this->sections[] = array('title' => __('图片延迟加载', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_lazyload', 'type' => 'switch', 'title' => __('是否启用图片延迟加载', 'salong'), 'subtitle' => __('默认启用', 'salong'), 'default' => true), array('id' => 'post_loading', 'type' => 'media', 'compiler' => true, 'readonly' => false, 'url' => true, 'title' => __('文章中默认图片', 'salong'), 'subtitle' => __('更新你的延迟加载文章中默认图片，添加gif图片，别太大就可以。', 'salong'), 'default' => array('url' => get_template_directory_uri() . '/images/post-loading.gif'), 'required' => array('switch_lazyload', 'equals', array('1'))), array('id' => 'thumb_loading', 'type' => 'media', 'compiler' => true, 'readonly' => false, 'url' => true, 'title' => __('缩略图默认图片', 'salong'), 'subtitle' => __('更新你的延迟加载缩略图默认图片，建议大小：460*280', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/images/thumb-loading.jpg'), 'required' => array('switch_lazyload', 'equals', array('1'))), array('id' => 'avatar_loading', 'type' => 'media', 'compiler' => true, 'readonly' => false, 'url' => true, 'title' => __('头像默认图片', 'salong'), 'subtitle' => __('更新你的头像默认图片，建议大小：80*80', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/images/favicon.png'), 'required' => array('switch_lazyload', 'equals', array('1')))));
            $this->sections[] = array('title' => __('ajax加载更多', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_loadmore', 'type' => 'switch', 'title' => __('ajax加载更多', 'salong'), 'subtitle' => __('默认启用，禁用则显示分页。', 'salong'), 'default' => true), array('id' => 'loadmore_count', 'type' => 'slider', 'title' => __('aja自动加载的次数', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：1、最大值：24、阶梯值：1、默认值：2。因为默认已经加载了一次，所以设置为0或1是不自动加载，设置为2时自动加载一次，依次类推。', 'salong'), 'default' => 2, 'min' => 1, 'step' => 1, 'max' => 24, 'display_value' => 'text', 'required' => array('switch_loadmore', 'equals', array('1'))), array('id' => 'loadmore_text', 'type' => 'text', 'title' => __('提示加载内容文本', 'salong'), 'subtitle' => __('当自动加载完成时，提示加载更多内容文本', 'salong'), 'default' => __('加载更多', 'salong'), 'required' => array('switch_loadmore', 'equals', array('1'))), array('id' => 'loadmore_end', 'type' => 'text', 'title' => __('内容加载完成文本', 'salong'), 'subtitle' => __('当所有内容加载结束后的提示文本', 'salong'), 'default' => __('已经加载到天涯海角了！', 'salong'), 'required' => array('switch_loadmore', 'equals', array('1')))));
            $this->sections[] = array('icon' => 'dashicons-menu', 'title' => '头部', 'fields' => array(array('id' => 'switch_header_show_hide', 'type' => 'switch', 'title' => __('头像随窗口显示与隐藏', 'salong'), 'subtitle' => __('默认开启。', 'salong'), 'default' => true), array('id' => 'switch_loginreg_menu', 'type' => 'switch', 'title' => __('是否显示登录与注册', 'salong'), 'subtitle' => __('默认显示，关闭后，投稿按钮和用户登录了个人中心菜单也将不显示。', 'salong'), 'default' => true), array('id' => 'switch_contribute_menu', 'type' => 'switch', 'title' => __('是否显示投稿按钮', 'salong'), 'subtitle' => __('默认显示。', 'salong'), 'default' => true), array('id' => 'contribute_field', 'type' => 'text', 'title' => __('投稿按钮字段', 'salong'), 'subtitle' => __('输入头部投稿按钮字段', 'salong'), 'default' => __('写文章', 'salong'), 'required' => array('switch_contribute_menu', 'equals', array('1')))));
            $this->sections[] = array('title' => __('搜索按钮', 'salong'), 'desc' => __('导航菜单中搜索按钮的设置。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_search_menu', 'type' => 'switch', 'title' => __('是否显示搜索按钮', 'salong'), 'subtitle' => __('默认显示。', 'salong'), 'default' => true), array('id' => 'search_post_cat', 'type' => 'select', 'data' => 'categories', 'multi' => true, 'sortable' => true, 'title' => __('热门文章分类', 'salong'), 'subtitle' => __('选择需要显示在搜索中的热门分类，可拖动进行排序，不选择则不显示热门搜索。', 'salong'), 'required' => array('switch_search_menu', 'equals', array('1'))), array('id' => 'search_topic_cat', 'type' => 'select', 'data' => 'categories', 'args' => array('taxonomy' => array('tcat')), 'multi' => true, 'sortable' => true, 'title' => __('热门专题分类', 'salong'), 'subtitle' => __('选择需要显示在搜索中的热门分类，可拖动进行排序，不选择则不显示热门搜索。', 'salong'), 'required' => array('switch_search_menu', 'equals', array('1'))), array('id' => 'search_download_cat', 'type' => 'select', 'data' => 'categories', 'args' => array('taxonomy' => array('dcat')), 'multi' => true, 'sortable' => true, 'title' => __('热门下载分类', 'salong'), 'subtitle' => __('选择需要显示在搜索中的热门分类，可拖动进行排序，不选择则不显示热门搜索。', 'salong'), 'required' => array('switch_search_menu', 'equals', array('1'))), array('id' => 'search_video_cat', 'type' => 'select', 'data' => 'categories', 'args' => array('taxonomy' => array('vcat')), 'multi' => true, 'sortable' => true, 'title' => __('热门视频分类', 'salong'), 'subtitle' => __('选择需要显示在搜索中的热门分类，可拖动进行排序，不选择则不显示热门搜索。', 'salong'), 'required' => array('switch_search_menu', 'equals', array('1'))), array('id' => 'search_product_cat', 'type' => 'select', 'data' => 'categories', 'args' => array('taxonomy' => array('product_cat')), 'multi' => true, 'sortable' => true, 'title' => __('热门产品分类', 'salong'), 'subtitle' => __('选择需要显示在搜索中的热门分类，可拖动进行排序，不选择则不显示热门搜索。', 'salong'), 'required' => array('switch_search_menu', 'equals', array('1')))));
            $this->sections[] = array('title' => __('微信小程序', 'salong'), 'desc' => __('导航菜单中微信小程序的设置。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_program_menu', 'type' => 'switch', 'title' => __('是否显示微信小程序二维码', 'salong'), 'subtitle' => __('默认显示。', 'salong'), 'default' => true), array('id' => 'program_title', 'type' => 'text', 'title' => __('标题', 'salong'), 'subtitle' => __('输入标题', 'salong'), 'default' => __('手机扫描浏览微信小程序', 'salong'), 'required' => array('switch_program_menu', 'equals', array('1'))), array('id' => 'program_qr', 'type' => 'media', 'compiler' => true, 'readonly' => false, 'url' => true, 'title' => __('微信小程序二维码', 'salong'), 'subtitle' => __('更新微信小程序二维码图片，建议大小258*258。', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/salongweb.png'), 'required' => array('switch_program_menu', 'equals', array('1')))));
            $this->sections[] = array('icon' => 'dashicons-admin-home', 'title' => __('首页', 'salong'), 'fields' => array(array('id' => 'home_layout', 'type' => 'sorter', 'title' => __('首页布局', 'salong'), 'subtitle' => __('首页内容部分的排列与显示，除幻灯片外，可选择显示与不显示，拖动可排序。', 'salong'), 'options' => array('enabled' => array('placebo' => 'placebo', 'home_new' => __('最新文章', 'salong'), 'home_cat_post' => __('文章分类', 'salong'), 'home_ad1' => __('首页广告1', 'salong'), 'home_topic' => __('最新专题', 'salong'), 'home_cat_topic' => __('专题分类', 'salong'), 'home_download' => __('最新下载', 'salong'), 'home_cat_download' => __('下载分类', 'salong'), 'home_ad2' => __('首页广告2', 'salong'), 'home_video' => __('最新视频', 'salong'), 'home_cat_video' => __('视频分类', 'salong'), 'home_product' => __('最新产品', 'salong'), 'home_cat_product' => __('产品分类', 'salong'), 'home_link' => __('友情链接', 'salong')), 'disabled' => array('placebo' => 'placebo')))));
            $this->sections[] = array('title' => __('幻灯片', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'slides_mode', 'type' => 'button_set', 'title' => __('幻灯片模式', 'salong'), 'options' => array('custom' => __('自定义', 'salong'), 'push' => __('文章推送', 'salong')), 'default' => 'custom', 'subtitle' => __('默认自定义幻灯片模式', 'salong'), 'desc' => __('选择幻灯片模式，自定义模式是可以自定义幻灯片（宽度为1200px，高度不限，但图片比例必须统一），文章推荐模式是获取推送到幻灯片中的文章（大小：595*380）。', 'salong')), array('id' => 'slides_home_list', 'type' => 'slides', 'title' => __('幻灯片选项', 'salong'), 'placeholder' => array('title' => __('标题', 'salong'), 'description' => __('描述', 'salong'), 'url' => __('链接', 'salong')), 'default' => array(array('title' => __('MNews 主题', 'salong'), 'description' => __('萨龙网络原创简约新闻自媒体类 WordPress 主题，特色：用户中心、用户关注、 WooCommerce 商城、产品筛选与排序、付费阅读、付费查看视频、付费查看下载地址、HTML5音视频播放器、微信分享显示缩略图、点赞收藏、评论评分、打赏、站内信、百度推送、阿里云视频点播和优酷视频、认证作者加 V、前台编辑文章、关灯看视频、视频播放列表等自媒体实用的功能。'), 'url' => 'https://salongweb.com/product/mnews.html', 'image' => 'https://demo.salongweb.com/mnews/images/slides/01.jpg'), array('title' => __('大理萨龙网络', 'salong'), 'description' => __('专注高端网站设计与开发，为您提供一个现代、干净的WEB站点！', 'salong'), 'url' => 'https://salongweb.com', 'image' => 'https://demo.salongweb.com/mnews/images/slides/02.jpg'), array('title' => __('定制高端WordPress主题', 'salong'), 'description' => __('高端个性化定制，一站式的网站建设服务，请联系我们！', 'salong'), 'url' => 'https://salongweb.com', 'image' => 'https://demo.salongweb.com/mnews/images/slides/03.jpg')), 'required' => array('slides_mode', 'equals', 'custom')), array('id' => 'slides_home_auto', 'type' => 'switch', 'title' => __('是否启用自动播放', 'salong'), 'subtitle' => __('默认启用', 'salong'), 'default' => true), array('id' => 'slides_home_effect', 'type' => 'switch', 'title' => __('是否启用左右切换效果', 'salong'), 'subtitle' => __('默认启用，关闭则为淡入淡出效果。', 'salong'), 'default' => true)));
            $this->sections[] = array('title' => __('置顶文章', 'salong'), 'subsection' => true, 'desc' => __('此选项当『幻灯片模式』为『自定义』时才需要设置，『文章推送』模式时是固定获取最新的4篇置顶文章。', 'salong'), 'fields' => array(array('id' => 'switch_home_sticky', 'type' => 'switch', 'title' => __('是否显示置顶文章', 'salong'), 'subtitle' => __('默认显示。', 'salong'), 'default' => true), array('id' => 'home_sticky_title', 'type' => 'text', 'title' => __('置顶文章标题', 'salong'), 'subtitle' => __('输入置顶文章标题', 'salong'), 'default' => __('精选导读', 'salong'), 'required' => array('switch_home_sticky', 'equals', array('1'))), array('id' => 'home_sticky_count', 'type' => 'slider', 'title' => __('数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：4、最大值：48、阶梯值：1、默认值：4。', 'salong'), 'default' => 4, 'min' => 4, 'step' => 1, 'max' => 48, 'display_value' => 'text', 'required' => array('switch_home_sticky', 'equals', array('1'))), array('id' => 'all_sticky_page', 'type' => 'select', 'data' => 'pages', 'title' => __('所有置顶文章页面', 'salong'), 'subtitle' => __('选择所有置顶文章页面。', 'salong'), 'required' => array('switch_home_sticky', 'equals', array('1')))));
            $this->sections[] = array('title' => __('最新文章', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'home_new_title', 'type' => 'text', 'title' => __('最新文章标题', 'salong'), 'subtitle' => __('输入最新文章标题', 'salong'), 'default' => __('最新文章', 'salong')), array('id' => 'exclude_new_cat', 'type' => 'select', 'data' => 'categories', 'multi' => true, 'sortable' => true, 'title' => __('排除分类', 'salong'), 'subtitle' => __('选择首页最新文章需要排除的文章分类，不选则显示全部最新文章。', 'salong')), array('id' => 'switch_today_post_count', 'type' => 'switch', 'title' => __('是否显示今日更新文章数量', 'salong'), 'subtitle' => __('默认显示，在标题右侧显示今日更新的文章数量，如果今日没有更新则不显示。', 'salong'), 'default' => true), array('id' => 'home_new_filter_cate', 'type' => 'select', 'data' => 'categories', 'multi' => true, 'sortable' => true, 'title' => __('筛选分类', 'salong'), 'subtitle' => __('选择首页最新文章需要筛选的文章分类。', 'salong'))));
            $this->sections[] = array('title' => __('文章分类', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'home_cat_post', 'type' => 'select', 'data' => 'categories', 'multi' => true, 'sortable' => true, 'title' => __('分类列表', 'salong'), 'subtitle' => __('选择需要显示的分类列表，可拖动进行排序，不选择则不显示分类列表。', 'salong')), array('id' => 'home_cat_count_post', 'type' => 'slider', 'title' => __('文章数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：4、最大值：24、阶梯值：4、默认值：4。', 'salong'), 'default' => 4, 'min' => 4, 'step' => 4, 'max' => 24, 'display_value' => 'text'), array('id' => 'switch_home_cat_post', 'type' => 'switch', 'title' => __('是否显示分类描述', 'salong'), 'subtitle' => __('默认显示。', 'salong'), 'default' => true)));
            $this->sections[] = array('title' => __('首页广告1', 'salong'), 'desc' => __('输入任意联盟广告和自定义广告的代码，页面包括所有文章列表页面，图片最大宽度为1200px。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'home_ad1', 'type' => 'editor', 'title' => __('桌面', 'salong'), 'subtitle' => __('输入桌面广告代码', 'salong'), 'default' => '<a href="https://salongweb.com" title="' . get_bloginfo('name') . '" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'args' => array('media_buttons' => true, 'textarea_rows' => 3))));
            $this->sections[] = array('title' => __('最新专题', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'home_topic_title', 'type' => 'text', 'title' => __('最新专题标题', 'salong'), 'subtitle' => __('输入最新专题标题', 'salong'), 'default' => __('精彩专题', 'salong')), array('id' => 'home_topic_desc', 'type' => 'text', 'title' => __('最新专题描述', 'salong'), 'subtitle' => __('输入最新专题描述', 'salong'), 'default' => __('精选优秀文章，系统化学习！', 'salong')), array('id' => 'home_topic_count', 'type' => 'slider', 'title' => __('专题数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：2、最大值：48、阶梯值：2、默认值：2。', 'salong'), 'default' => 2, 'min' => 2, 'step' => 2, 'max' => 48, 'display_value' => 'text'), array('id' => 'home_topic_post_count', 'type' => 'slider', 'title' => __('专题文章数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：0、最大值：48、阶梯值：1、默认值：3。', 'salong'), 'default' => 3, 'min' => 0, 'step' => 1, 'max' => 48, 'display_value' => 'text'), array('id' => 'exclude_topic_cat', 'type' => 'select', 'data' => 'categories', 'args' => array('taxonomy' => array('tcat')), 'multi' => true, 'sortable' => true, 'title' => __('排除分类', 'salong'), 'subtitle' => __('选择首页最新专题需要排除的专题分类，不选则显示全部最新专题。', 'salong'))));
            $this->sections[] = array('title' => __('专题分类', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'home_cat_topic', 'type' => 'select', 'data' => 'categories', 'args' => array('taxonomy' => array('tcat')), 'multi' => true, 'sortable' => true, 'title' => __('分类列表', 'salong'), 'subtitle' => __('选择需要显示的分类列表，可拖动进行排序，不选择则不显示分类列表。', 'salong')), array('id' => 'home_cat_count_topic', 'type' => 'slider', 'title' => __('文章数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：2、最大值：24、阶梯值：2、默认值：2。', 'salong'), 'default' => 2, 'min' => 2, 'step' => 2, 'max' => 24, 'display_value' => 'text'), array('id' => 'switch_home_cat_topic', 'type' => 'switch', 'title' => __('是否显示分类描述', 'salong'), 'subtitle' => __('默认显示。', 'salong'), 'default' => true)));
            $this->sections[] = array('title' => __('最新下载', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'home_download_title', 'type' => 'text', 'title' => __('最新下载标题', 'salong'), 'subtitle' => __('输入最新下载标题', 'salong'), 'default' => __('工具下载', 'salong')), array('id' => 'home_download_desc', 'type' => 'text', 'title' => __('最新下载描述', 'salong'), 'subtitle' => __('输入最新下载描述', 'salong'), 'default' => __('工欲善其事，必先利其器！', 'salong')), array('id' => 'home_download_count', 'type' => 'slider', 'title' => __('下载数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：4、最大值：48、阶梯值：4、默认值：4。', 'salong'), 'default' => 4, 'min' => 4, 'step' => 4, 'max' => 48, 'display_value' => 'text'), array('id' => 'exclude_download_cat', 'type' => 'select', 'data' => 'categories', 'args' => array('taxonomy' => array('dcat')), 'multi' => true, 'sortable' => true, 'title' => __('排除分类', 'salong'), 'subtitle' => __('选择首页最新下载需要排除的下载分类，不选则显示全部最新下载。', 'salong'))));
            $this->sections[] = array('title' => __('下载分类', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'home_cat_download', 'type' => 'select', 'data' => 'categories', 'args' => array('taxonomy' => array('dcat')), 'multi' => true, 'sortable' => true, 'title' => __('分类列表', 'salong'), 'subtitle' => __('选择需要显示的分类列表，可拖动进行排序，不选择则不显示分类列表。', 'salong')), array('id' => 'home_cat_count_download', 'type' => 'slider', 'title' => __('文章数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：3、最大值：24、阶梯值：3、默认值：3。', 'salong'), 'default' => 3, 'min' => 3, 'step' => 3, 'max' => 24, 'display_value' => 'text'), array('id' => 'switch_home_cat_download', 'type' => 'switch', 'title' => __('是否显示分类描述', 'salong'), 'subtitle' => __('默认显示。', 'salong'), 'default' => true)));
            $this->sections[] = array('title' => __('首页广告2', 'salong'), 'desc' => __('输入任意联盟广告和自定义广告的代码，页面包括所有文章列表页面，图片最大宽度为1200px。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'home_ad2', 'type' => 'editor', 'title' => __('桌面', 'salong'), 'subtitle' => __('输入桌面广告代码', 'salong'), 'default' => '<a href="https://salongweb.com" title="' . get_bloginfo('name') . '" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'args' => array('media_buttons' => true, 'textarea_rows' => 3))));
            $this->sections[] = array('title' => __('最新视频', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'home_video_title', 'type' => 'text', 'title' => __('最新视频标题', 'salong'), 'subtitle' => __('输入最新视频标题', 'salong'), 'default' => __('精选视频', 'salong')), array('id' => 'home_video_desc', 'type' => 'text', 'title' => __('最新视频描述', 'salong'), 'subtitle' => __('输入最新视频描述', 'salong'), 'default' => __('精选优质视频，皮克斯优秀动画短片，BBS 优秀纪录片，丰富您的视听体验。', 'salong')), array('id' => 'home_video_count', 'type' => 'slider', 'title' => __('视频数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：4、最大值：48、阶梯值：1、默认值：4。', 'salong'), 'default' => 4, 'min' => 4, 'step' => 1, 'max' => 48, 'display_value' => 'text'), array('id' => 'exclude_video_cat', 'type' => 'select', 'data' => 'categories', 'args' => array('taxonomy' => array('vcat')), 'multi' => true, 'sortable' => true, 'title' => __('排除分类', 'salong'), 'subtitle' => __('选择首页最新视频需要排除的视频分类，不选则显示全部最新视频。', 'salong'))));
            $this->sections[] = array('title' => __('视频分类', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'home_cat_video', 'type' => 'select', 'data' => 'categories', 'args' => array('taxonomy' => array('vcat')), 'multi' => true, 'sortable' => true, 'title' => __('分类列表', 'salong'), 'subtitle' => __('选择需要显示的分类列表，可拖动进行排序，不选择则不显示分类列表。', 'salong')), array('id' => 'home_cat_count_video', 'type' => 'slider', 'title' => __('文章数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：4、最大值：24、阶梯值：4、默认值：4。', 'salong'), 'default' => 4, 'min' => 4, 'step' => 4, 'max' => 24, 'display_value' => 'text'), array('id' => 'switch_home_cat_video', 'type' => 'switch', 'title' => __('是否显示分类描述', 'salong'), 'subtitle' => __('默认显示。', 'salong'), 'default' => true)));
            $this->sections[] = array('title' => __('最新产品', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'home_product_title', 'type' => 'text', 'title' => __('最新产品标题', 'salong'), 'subtitle' => __('输入最新产品标题', 'salong'), 'default' => __('原创主题', 'salong')), array('id' => 'home_product_desc', 'type' => 'text', 'title' => __('最新产品描述', 'salong'), 'subtitle' => __('输入最新产品描述', 'salong'), 'default' => __('萨龙网络原创精致 WordPress 主题，设计简约、大气，功能强大、实用。', 'salong')), array('id' => 'home_product_count', 'type' => 'slider', 'title' => __('产品数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：4、最大值：48、阶梯值：1、默认值：4。', 'salong'), 'default' => 4, 'min' => 4, 'step' => 1, 'max' => 48, 'display_value' => 'text'), array('id' => 'exclude_product_cat', 'type' => 'select', 'data' => 'categories', 'args' => array('taxonomy' => array('product_cat')), 'multi' => true, 'sortable' => true, 'title' => __('排除分类', 'salong'), 'subtitle' => __('选择首页最新产品需要排除的产品分类，不选则显示全部最新产品。', 'salong'))));
            $this->sections[] = array('title' => __('产品分类', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'home_cat_product', 'type' => 'select', 'data' => 'categories', 'args' => array('taxonomy' => array('product_cat')), 'multi' => true, 'sortable' => true, 'title' => __('分类列表', 'salong'), 'subtitle' => __('选择需要显示的分类列表，可拖动进行排序，不选择则不显示分类列表。', 'salong')), array('id' => 'home_cat_count_product', 'type' => 'slider', 'title' => __('文章数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：4、最大值：24、阶梯值：4、默认值：4。', 'salong'), 'default' => 4, 'min' => 4, 'step' => 4, 'max' => 24, 'display_value' => 'text'), array('id' => 'switch_home_cat_product', 'type' => 'switch', 'title' => __('是否显示分类描述', 'salong'), 'subtitle' => __('默认显示。', 'salong'), 'default' => true)));
            $this->sections[] = array('title' => __('友情链接', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'home_link_title', 'type' => 'text', 'title' => __('友情链接标题', 'salong'), 'subtitle' => __('输入友情链接标题', 'salong'), 'default' => __('友情链接', 'salong')), array('id' => 'home_link_count', 'type' => 'slider', 'title' => __('数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：4、最大值：48、阶梯值：1、默认值：12。', 'salong'), 'default' => 12, 'min' => 4, 'step' => 1, 'max' => 48, 'display_value' => 'text'), array('id' => 'home_link_cat', 'type' => 'select', 'data' => 'categories', 'args' => array('taxonomy' => array('link_category')), 'multi' => true, 'sortable' => true, 'title' => __('链接分类', 'salong'), 'subtitle' => __('选择需要显示的链接分类，拖动分类可进行排序，不选择则显示全部链接。', 'salong')), array('id' => 'home_exclude_link', 'type' => 'text', 'title' => __('排除链接', 'salong'), 'subtitle' => __('输入需要排除的友情链接，格式：1,2,3（后台不能获取友情链接，所以需要前往友情链接中查看链接的ID)', 'salong')), array('id' => 'home_link_orderby', 'type' => 'select', 'title' => __('链接排序', 'salong'), 'subtitle' => __('链接的排列顺序，可选择以下几种，默认随机', 'salong'), 'options' => array('rand' => __('随机', 'salong'), 'name' => __('标题', 'salong'), 'link_id' => 'ID', 'target' => __('目标', 'salong'), 'description' => __('描述', 'salong'), 'rating' => __('等级', 'salong'), 'updated' => __('更新', 'salong'), 'rel' => __('链接关系', 'salong'), 'notes' => __('注释', 'salong'), 'rss' => 'RSS', 'length' => __('名称长度', 'salong')), 'default' => 'rand'), array('id' => 'home_link_order', 'type' => 'select', 'title' => __('链接升序或降序', 'salong'), 'subtitle' => __('链接的升序或降序，默认升序', 'salong'), 'options' => array('asc' => __('升序', 'salong'), 'desc' => __('降序', 'salong')), 'default' => 'desc'), array('id' => 'home_link_url', 'type' => 'select', 'data' => 'pages', 'title' => __('全部友情链接页面', 'salong'), 'subtitle' => __('选择友情链接页面。', 'salong')), array('id' => 'switch_home_link_icon', 'type' => 'switch', 'title' => __('是否显示友情链接图标', 'salong'), 'subtitle' => __('默认显示，获取图标的功能是使用第三方的链接，如果不显示图标，请关闭。', 'salong'), 'default' => true)));
            $this->sections[] = array('icon' => 'dashicons-businessman', 'title' => __('用户中心', 'salong'), 'fields' => array(array('id' => 'admin_access', 'title' => __('允许访问后台', 'salong'), 'subtitle' => __('允许哪些用户角色访问WordPress后台，同时对能进入后台的用户的文章列表中的草稿和审核中的文章不显示，可直接进入后台编辑。', 'salong'), 'type' => 'select', 'default' => 'edit_others_posts', 'options' => array('manage_options' => __('仅管理员', 'salong'), 'edit_others_posts' => __('管理员、编辑', 'salong'), 'publish_posts' => __('管理员、编辑、作者', 'salong'), 'edit_posts' => __('管理员、编辑、作者、投稿者', 'salong'), 'read' => __('管理员、编辑、作者、投稿者、订阅者', 'salong'))), array('id' => 'vip_access', 'title' => __('直接显示付费内容', 'salong'), 'subtitle' => __('请选择对哪些角色的用户直接显示付费内容而不需要付费。', 'salong'), 'type' => 'select', 'default' => 'edit_others_posts', 'options' => array('manage_options' => __('仅管理员', 'salong'), 'edit_others_posts' => __('管理员、编辑', 'salong'), 'publish_posts' => __('管理员、编辑、作者', 'salong'), 'edit_posts' => __('管理员、编辑、作者、投稿者', 'salong'), 'read' => __('管理员、编辑、作者、投稿者、订阅者', 'salong'))), array('id' => 'admin_field', 'type' => 'text', 'title' => __('管理员字样', 'salong'), 'subtitle' => __('输入管理员字样，默认为『官方』，为空则不显示。', 'salong'), 'default' => __('官方', 'salong')), array('id' => 'editor_field', 'type' => 'text', 'title' => __('编辑字样', 'salong'), 'subtitle' => __('输入编辑字样，默认为『编辑』，为空则不显示。', 'salong'), 'default' => __('编辑', 'salong')), array('id' => 'author_user_count', 'type' => 'slider', 'title' => __('关注与粉丝的数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：1、最大值：48、阶梯值：1、默认值：12。', 'salong'), 'default' => 12, 'min' => 1, 'step' => 1, 'max' => 48, 'display_value' => 'text'), array('id' => 'following_posts_count', 'type' => 'slider', 'title' => __('所关注用户最新文章数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：1、最大值：48、阶梯值：1、默认值：12。', 'salong'), 'default' => 12, 'min' => 1, 'step' => 1, 'max' => 48, 'display_value' => 'text'), array('id' => 'switch_author_id', 'type' => 'switch', 'title' => __('作者归档使用 ID 形式', 'salong'), 'subtitle' => __('默认启用', 'salong'), 'desc' => __('作者归档链接为：https://salongweb.com/author/1，禁用作者归档链接则为：https://salongweb.com/author/sll，操作后请再保存下固定链接。', 'salong'), 'default' => true), array('id' => 'switch_edit_post', 'type' => 'switch', 'title' => __('是否允许用户编辑草稿', 'salong'), 'subtitle' => __('默认启用，在个人中心的文章列表中的草稿上显示编辑按钮，只限文章为草稿状态时可编辑。', 'salong'), 'default' => true), array('id' => 'switch_admin_bar', 'type' => 'switch', 'title' => __('是否显示工具栏', 'salong'), 'subtitle' => __('默认启用，只对『允许访问后台』的用户显示，禁用后对于任何角色前台都不显示工具栏。', 'salong'), 'default' => true), array('id' => 'switch_user_add_email', 'type' => 'switch', 'title' => __('是否启用社交登录用户更新资料', 'salong'), 'subtitle' => __('默认禁用，社交用户登录时，用户邮箱是没有，昵称也不规则的，所以跳转到更新资料的页面。', 'salong'), 'default' => false)));
            $this->sections[] = array('title' => __('站内信', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_messages', 'type' => 'switch', 'title' => __('是否启用站内信功能', 'salong'), 'subtitle' => __('默认启用，用户之前可以互相发送信息。', 'salong'), 'default' => true), array('id' => 'messages_recipient_select', 'title' => __('收件人选择方式', 'salong'), 'subtitle' => __('下拉列表可直观选择用户，后台可多选，前台只能选择一个用户，输入提示会根据用户输入关键字来 ajax 显示用户。', 'salong'), 'type' => 'select', 'default' => 'dropdown', 'options' => array('dropdown' => __('下拉列表', 'salong'), 'autosuggest' => __('输入提示', 'salong')), 'required' => array('switch_messages', 'equals', array('1'))), array('id' => 'messages_indent', 'type' => 'section', 'indent' => true, 'title' => __('站内信数量', 'salong'), 'subtitle' => __('0 表示无限制，-1表示不允许发送站内信。', 'salong'), 'required' => array('switch_messages', 'equals', array('1'))), array('id' => 'messages_count_administrator', 'type' => 'slider', 'title' => __('管理员站内信数量', 'salong'), 'desc' => __('输入数值或拖动滑块，滑块说明：最小值：-1、最大值：1000、阶梯值：1、默认值：0。', 'salong'), 'default' => 0, 'min' => -1, 'step' => 1, 'max' => 1000, 'display_value' => 'text'), array('id' => 'messages_count_editor', 'type' => 'slider', 'title' => __('编辑站内信数量', 'salong'), 'desc' => __('输入数值或拖动滑块，滑块说明：最小值：-1、最大值：1000、阶梯值：1、默认值：50。', 'salong'), 'default' => 50, 'min' => -1, 'step' => 1, 'max' => 1000, 'display_value' => 'text'), array('id' => 'messages_count_author', 'type' => 'slider', 'title' => __('作者站内信数量', 'salong'), 'desc' => __('输入数值或拖动滑块，滑块说明：最小值：-1、最大值：1000、阶梯值：1、默认值：20。', 'salong'), 'default' => 20, 'min' => -1, 'step' => 1, 'max' => 1000, 'display_value' => 'text'), array('id' => 'messages_count_contributor', 'type' => 'slider', 'title' => __('投稿者站内信数量', 'salong'), 'desc' => __('输入数值或拖动滑块，滑块说明：最小值：-1、最大值：1000、阶梯值：1、默认值：10。', 'salong'), 'default' => 10, 'min' => -1, 'step' => 1, 'max' => 1000, 'display_value' => 'text'), array('id' => 'messages_count_subscriber', 'type' => 'slider', 'title' => __('订阅者站内信数量', 'salong'), 'desc' => __('输入数值或拖动滑块，滑块说明：最小值：-1、最大值：1000、阶梯值：1、默认值：5。', 'salong'), 'default' => 5, 'min' => -1, 'step' => 1, 'max' => 1000, 'display_value' => 'text'), array('id' => 'messages_email_indent', 'type' => 'section', 'indent' => true, 'title' => __('邮件通知', 'salong'), 'subtitle' => __('可用标签：<code>%BLOG_NAME%</code>博客名称，<code>%BLOG_ADDRESS%</code>安装博客的Email地址，<code>%SENDER%</code>发送人名称，<code>%INBOX_URL%</code>收件箱URL', 'salong'), 'required' => array('switch_messages', 'equals', array('1'))), array('id' => 'switch_messages_email', 'type' => 'switch', 'title' => __('是否启用邮件通知', 'salong'), 'subtitle' => __('默认启用，当用户收到站内信时通过Email通知。', 'salong'), 'default' => true), array('id' => 'messages_email_name', 'type' => 'text', 'title' => __('名称', 'salong'), 'subtitle' => __('输入邮件来源名称，可选。', 'salong'), 'default' => '%BLOG_NAME%'), array('id' => 'messages_email_address', 'type' => 'text', 'title' => __('邮箱', 'salong'), 'subtitle' => __('输入邮件来源邮箱，可选。', 'salong'), 'default' => '%BLOG_ADDRESS%'), array('id' => 'messages_email_subject', 'type' => 'text', 'title' => __('主题', 'salong'), 'subtitle' => __('输入邮件来源主题。', 'salong'), 'default' => __('从%BLOG_NAME%发来新的站内信', 'salong')), array('id' => 'messages_email_content', 'type' => 'editor', 'title' => __('内容', 'salong'), 'subtitle' => __('输入邮件内容，允许使用的HTML标签', 'salong'), 'default' => __('您有新的站内信来自<b>%SENDER%</b>，在<b>%BLOG_NAME%</b>。<br><a href="%INBOX_URL%">点击这里</a> 进入您的收件箱。<br>此邮件是自动发出，请不要回复！', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'messages_indent', 'type' => 'section', 'indent' => false)));
            $this->sections[] = array('title' => __('用户关注', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_follow_btn', 'type' => 'switch', 'title' => __('是否启用用户关注', 'salong'), 'subtitle' => __('默认启用，用户之前可以实现关注与粉丝功能。', 'salong'), 'default' => true), array('id' => 'author_user_count', 'type' => 'slider', 'title' => __('关注与粉丝的数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：1、最大值：48、阶梯值：1、默认值：12。', 'salong'), 'default' => 12, 'min' => 1, 'step' => 1, 'max' => 48, 'display_value' => 'text', 'required' => array('switch_follow_btn', 'equals', array('1'))), array('id' => 'following_posts_count', 'type' => 'slider', 'title' => __('所关注用户最新文章数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：1、最大值：48、阶梯值：1、默认值：12。', 'salong'), 'default' => 12, 'min' => 1, 'step' => 1, 'max' => 48, 'display_value' => 'text', 'required' => array('switch_follow_btn', 'equals', array('1')))));
            $this->sections[] = array('title' => __('投稿设置', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_user_media', 'type' => 'switch', 'title' => __('只显示用户上传的文件', 'salong'), 'subtitle' => __('默认启用，在媒体库中只显示当前用户所上传的媒体文件。', 'salong'), 'default' => true), array('id' => 'switch_upload_filter', 'type' => 'switch', 'title' => __('上传图片文件自动重命名', 'salong'), 'subtitle' => __('默认启用，文件将以时间来重命名。', 'salong'), 'default' => true), array('id' => 'switch_contributor_uploads', 'type' => 'switch', 'title' => __('允许投稿者上传媒体', 'salong'), 'subtitle' => __('默认启用，禁用后投稿中的『添加媒体』按钮将不显示，投稿者也不能上传媒体。', 'salong'), 'default' => true), array('id' => 'switch_tougao_notify', 'type' => 'switch', 'title' => __('投稿成功给投稿者发送邮件', 'salong'), 'subtitle' => __('默认启用，禁用后投稿成功不给投稿者发送邮件。', 'salong'), 'default' => true), array('id' => 'salong_upload_filetypes', 'type' => 'text', 'title' => __('允许上传的文件类型', 'salong'), 'subtitle' => __('输入文件后缀，多个后缀以空格隔开。', 'salong'), 'desc' => __('此选项对多站点，后台和管理员无效，多站点可在『我的站点——管理网络——设置——网络设置——上传文件类型』中设置。', 'salong'), 'default' => 'jpg jpeg png gif'), array('id' => 'tg_time', 'type' => 'slider', 'title' => __('投稿间隔时间', 'salong'), 'subtitle' => __('输入多次投稿时的间隔时间，单位为秒，默认为120秒，最小值为0，阶梯值为5，最大值为3000', 'salong'), 'default' => '120', 'min' => 0, 'step' => 5, 'max' => 3000, 'display_value' => 'text'), array('id' => 'image_width', 'type' => 'slider', 'title' => __('图片最大宽度', 'salong'), 'subtitle' => __('输入用户上传图片的最大宽度，默认为：1000，最小值为0，阶梯值为10，最大值为10000', 'salong'), 'default' => 1000, 'min' => 0, 'step' => 10, 'max' => 10000, 'display_value' => 'text'), array('id' => 'image_height', 'type' => 'slider', 'title' => __('图片最大高度度', 'salong'), 'subtitle' => __('输入用户上传图片的最大高度度，默认为：500，最小值为0，阶梯值为10，最大值为10000', 'salong'), 'default' => 500, 'min' => 0, 'step' => 10, 'max' => 10000, 'display_value' => 'text'), array('id' => 'contribute_access', 'title' => __('允许投稿权限', 'salong'), 'subtitle' => __('允许哪些用户角色投稿。', 'salong'), 'type' => 'select', 'default' => 'edit_posts', 'options' => array('manage_options' => __('仅管理员', 'salong'), 'edit_others_posts' => __('管理员、编辑', 'salong'), 'publish_posts' => __('管理员、编辑、作者', 'salong'), 'edit_posts' => __('管理员、编辑、作者、投稿者', 'salong'), 'read' => __('管理员、编辑、作者、投稿者、订阅者', 'salong'))), array('id' => 'direct_contribute_access', 'title' => __('直接投稿权限', 'salong'), 'subtitle' => __('请选择对哪些角色的用户投稿后直接发布，而不需要审核。', 'salong'), 'type' => 'select', 'default' => 'edit_others_posts', 'options' => array('manage_options' => __('仅管理员', 'salong'), 'edit_others_posts' => __('管理员、编辑', 'salong'), 'publish_posts' => __('管理员、编辑、作者', 'salong'), 'edit_posts' => __('管理员、编辑、作者、投稿者', 'salong'), 'read' => __('管理员、编辑、作者、投稿者、订阅者', 'salong'))), array('id' => 'contribute_cat', 'type' => 'select', 'data' => 'categories', 'multi' => true, 'sortable' => true, 'title' => __('选择投稿分类', 'salong'), 'subtitle' => __('用户中心中文章投稿要显示的分类，不选择则显示所有分类。', 'salong'))));
            $this->sections[] = array('title' => __('投稿说明', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'contribute_info', 'type' => 'editor', 'title' => __('投稿说明', 'salong'), 'subtitle' => __('输入投稿说明。', 'salong'), 'default' => __('请确保所有内容都按规定填写，且保证『本站名称』输入正确，提交审核后将不能再编辑文章，保存草稿后可再编辑！', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'contribute_access_info', 'type' => 'editor', 'title' => __('没有投稿权限说明', 'salong'), 'subtitle' => __('输入没有投稿权限说明。', 'salong'), 'default' => __('您没有投稿权限，请联系管理员！', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'contribute_init_pending', 'type' => 'editor', 'title' => __('投稿审核说明', 'salong'), 'subtitle' => __('输入投稿成功且状态为审核时的说明。', 'salong'), 'default' => __('感谢投稿！文章已提交审核，文章审核通过发布后将收到邮件通知，请耐心等待。', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'contribute_init_draft', 'type' => 'editor', 'title' => __('投稿草稿说明', 'salong'), 'subtitle' => __('输入投稿成功且状态为草稿时的说明。', 'salong'), 'default' => __('感谢投稿！文章提交为草稿，您还可以在『个人中心——文章』列表中编辑该文章，确认无误请提交审核。', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'contribute_init_publish', 'type' => 'editor', 'title' => __('投稿直接发布说明', 'salong'), 'subtitle' => __('输入投稿成功且状态为已发布时的说明。', 'salong'), 'default' => __('感谢投稿！文章提交并已发布。', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'contribute_email_pending', 'type' => 'editor', 'title' => __('投稿为审核中的邮件说明', 'salong'), 'subtitle' => __('输入投稿为审核中的邮件说明，邮件是发送给网站管理员。', 'salong'), 'default' => get_bloginfo('name') . __('有用户投稿，并提交审核，请尽快审阅！', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'contribute_email_draft', 'type' => 'editor', 'title' => __('投稿为草稿的邮件说明', 'salong'), 'subtitle' => __('输入投稿为草稿的邮件说明，邮件是发送给网站管理员。', 'salong'), 'default' => get_bloginfo('name') . __('有用户投稿，状态为草稿，等待用户提交审核！', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'contribute_email_publish', 'type' => 'editor', 'title' => __('投稿直接发布的邮件说明', 'salong'), 'subtitle' => __('输入投稿直接发布的邮件说明，邮件是发送给网站管理员。', 'salong'), 'default' => get_bloginfo('name') . __('有用户投稿，已经发布！', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3))));
            $this->sections[] = array('title' => __('投稿字数', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'post_tg_min', 'type' => 'slider', 'title' => __('文章投稿内容最少字数', 'salong'), 'subtitle' => __('输入投稿内容最少字数，默认为：100，最小值为0，阶梯值为10，最大值为1000', 'salong'), 'default' => '100', 'min' => 0, 'step' => 10, 'max' => 1000, 'display_value' => 'text'), array('id' => 'post_tg_max', 'type' => 'slider', 'title' => __('文章投稿内容最多字数', 'salong'), 'subtitle' => __('输入投稿内容最多字数，默认为：3000，最小值为0，阶梯值为100，最大值为100000', 'salong'), 'default' => 3000, 'min' => 0, 'step' => 100, 'max' => 100000, 'display_value' => 'text')));
            $this->sections[] = array('icon' => 'dashicons-wordpress-alt', 'title' => __('博客', 'salong'), 'fields' => array(array('id' => 'blog_metas', 'type' => 'button_set', 'multi' => true, 'title' => __('博客METAS', 'salong'), 'options' => array('author' => __('作者', 'salong'), 'category' => __('分类', 'salong'), 'date' => __('日期', 'salong'), 'view' => __('浏览', 'salong'), 'comment' => __('评论', 'salong'), 'like' => __('点赞', 'salong')), 'default' => array('author', 'category', 'date', 'view', 'comment', 'like'), 'subtitle' => __('选择文章Metas的显示。', 'salong')), array('id' => 'post_column_metas', 'type' => 'button_set', 'multi' => true, 'title' => __('后台文章列表栏目', 'salong'), 'options' => array('modified' => __('最后修改时间', 'salong'), 'views' => __('浏览', 'salong'), 'likes' => __('点赞', 'salong'), 'post_id' => __('文章ID', 'salong'), 'thumb' => __('缩略图', 'salong'), 'slide' => __('幻灯片推送', 'salong'), 'baidusubmit' => __('百度推送', 'salong'), 'time' => __('视频时长', 'salong')), 'default' => array('modified', 'views', 'likes', 'thumb', 'slide', 'baidusubmit', 'time'), 'subtitle' => __('选择后台文章列表需要显示的栏目。', 'salong'), 'desc' => __('主题增加了：最后修改时间、浏览、点赞、缩略图、幻灯片推送和百度推送，6个选项，可对文章进行排序，后四个选项可对文章列表进行筛选，缩略图、幻灯片推送和百度推送按发布时间排序，幻灯片推送只有默认文章才有。', 'salong')), array('id' => 'post_sticky_text', 'type' => 'text', 'title' => __('置顶文章字符', 'salong'), 'subtitle' => __('输入置顶文章标题前的字符。', 'salong'), 'default' => __('[置顶]', 'salong')),array('id' => 'switch_post_cat_order', 'type' => 'switch', 'title' => __('是否显示分类排序', 'salong'), 'subtitle' => __('默认显示，在所有文章与分类列表将显示分类与排序模块。', 'salong'), 'default' => true),array('id' => 'switch_post_copyright', 'type' => 'switch', 'title' => __('是否显示文章版本说明', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'switch_post_prevnext', 'type' => 'switch', 'title' => __('是否显示上下篇', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'switch_highlight', 'type' => 'switch', 'title' => __('是否显示代码高亮', 'salong'), 'subtitle' => __('默认开启', 'salong'), 'default' => true)));
            $this->sections[] = array('title' => __('相关文章', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_post_related', 'type' => 'switch', 'title' => __('是否显示相关文章', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'post_related_rule', 'type' => 'button_set', 'title' => __('获取规则', 'salong'), 'options' => array('cat' => __('分类', 'salong'), 'tag' => __('标签', 'salong')), 'default' => 'cat', 'subtitle' => __('默认以分类来获取相关文章', 'salong')), array('id' => 'post_related_title', 'type' => 'text', 'title' => __('标题', 'salong'), 'default' => __('相关文章', 'salong'), 'required' => array('switch_post_related', 'equals', array('1'))), array('id' => 'post_related_count', 'type' => 'slider', 'title' => __('数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：3、最大值：24、阶梯值：1、默认值：3。', 'salong'), 'default' => 3, 'min' => 3, 'step' => 1, 'max' => 24, 'display_value' => 'text', 'required' => array('switch_post_related', 'equals', array('1')))));
            $this->sections[] = array('icon' => 'dashicons-megaphone', 'title' => __('快讯', 'salong'), 'fields' => array(array('id' => 'kx_metas', 'type' => 'button_set', 'multi' => true, 'title' => __('快讯METAS', 'salong'), 'options' => array('time' => __('时间', 'salong'), 'view' => __('浏览', 'salong')), 'default' => array('time', 'view'), 'subtitle' => __('选择文章列表Metas的显示。', 'salong')), array('id' => 'switch_kx_field_sift', 'type' => 'switch', 'title' => __('是否显示字段筛选', 'salong'), 'subtitle' => __('默认显示，在所有快讯将显示字段筛选模块。', 'salong'), 'default' => true), array('id' => 'salong_kx_sift_name', 'type' => 'text', 'title' => __('筛选名称', 'salong'), 'subtitle' => __('输入快讯筛选名称。', 'salong'), 'default' => __('筛选快讯：', 'salong'),'required' => array('switch_kx_field_sift','equals',array('1'))),array('id' => 'salong_kx_from_name', 'type' => 'text', 'title' => __('来源名称', 'salong'), 'subtitle' => __('输入快讯来源名称。', 'salong'), 'default' => __('[消息来源]', 'salong')))); 
            $this->sections[] = array('title' => __('文章类型', 'salong'), 'desc' => __('快讯文章类型的相关设置。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_kx_type', 'type' => 'switch', 'title' => __('是否显示快讯类型文章', 'salong'), 'subtitle' => __('默认显示，关闭则所有快讯设置将无效。', 'salong'), 'default' => true), array('id' => 'kx_post_slug', 'type' => 'text', 'title' => __('快讯链接别名', 'salong'), 'subtitle' => __('输入快讯类型文章链接别名，设置后请再保存下固定链接。', 'salong'), 'default' => __('kx', 'salong'), 'required' => array('switch_kx_type', 'equals', array('1')))));
            $this->sections[] = array('title' => __('筛选信息', 'salong'), 'desc' => __('产品筛选功能需要增加其它字段，需要定制，请联系我们。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'sift_field', 'type' => 'textarea', 'title' => __('字段', 'salong'), 'subtitle' => __('输入快讯字段，格式：f1=自媒体，一行一个。', 'salong'), 'default' => __('f1=自媒体 f2=大公司 f3=人工智能 f4=生活服务 f5=智慧城市 f6=云计算', 'salong'))));
            $this->sections[] = array('icon' => 'dashicons-flag', 'title' => __('专题', 'salong'), 'fields' => array(array('id' => 'topic_metas', 'type' => 'button_set', 'multi' => true, 'title' => __('专题METAS', 'salong'), 'options' => array('author' => __('作者', 'salong'), 'category' => __('分类', 'salong'), 'date' => __('日期', 'salong'), 'view' => __('浏览', 'salong'), 'like' => __('点赞', 'salong'), 'post_count' => __('文章数量', 'salong')), 'default' => array('author', 'category', 'date', 'view', 'post_count', 'like'), 'subtitle' => __('选择文章列表Metas的显示。', 'salong')), array('id' => 'switch_topic_cat_order', 'type' => 'switch', 'title' => __('是否显示分类排序', 'salong'), 'subtitle' => __('默认显示，在所有专题与分类列表将显示分类与排序模块。', 'salong'), 'default' => true), array('id' => 'switch_topic_prevnext', 'type' => 'switch', 'title' => __('是否显示上下篇', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true)));
            $this->sections[] = array('title' => __('文章类型', 'salong'), 'desc' => __('专题文章类型的相关设置。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_topic_type', 'type' => 'switch', 'title' => __('是否显示专题类型文章', 'salong'), 'subtitle' => __('默认显示，关闭则所有专题设置将无效。', 'salong'), 'default' => true), array('id' => 'topic_post_slug', 'type' => 'text', 'title' => __('专题链接别名', 'salong'), 'subtitle' => __('输入专题类型文章链接别名，设置后请再保存下固定链接。', 'salong'), 'default' => __('topic', 'salong'), 'required' => array('switch_topic_type', 'equals', array('1')))));
            $this->sections[] = array('title' => __('相关专题', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_topic_related', 'type' => 'switch', 'title' => __('是否显示相关专题', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'topic_related_rule', 'type' => 'button_set', 'title' => __('获取规则', 'salong'), 'options' => array('cat' => __('分类', 'salong'), 'tag' => __('标签', 'salong')), 'default' => 'cat', 'subtitle' => __('默认以分类来获取相关文章', 'salong')), array('id' => 'topic_related_title', 'type' => 'text', 'title' => __('标题', 'salong'), 'default' => __('相关专题', 'salong'), 'required' => array('switch_topic_related', 'equals', array('1'))), array('id' => 'topic_related_count', 'type' => 'slider', 'title' => __('数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：2、最大值：24、阶梯值：1、默认值：4。', 'salong'), 'default' => 4, 'min' => 2, 'step' => 1, 'max' => 24, 'display_value' => 'text', 'required' => array('switch_topic_related', 'equals', array('1')))));
            $this->sections[] = array('icon' => 'dashicons-download', 'title' => __('下载', 'salong'), 'fields' => array(array('id' => 'download_metas', 'type' => 'button_set', 'multi' => true, 'title' => __('下载METAS', 'salong'), 'options' => array('author' => __('作者', 'salong'), 'category' => __('分类', 'salong'), 'date' => __('日期', 'salong'), 'view' => __('浏览', 'salong'), 'like' => __('点赞', 'salong'), 'download' => __('下载', 'salong')), 'default' => array('author', 'category', 'date', 'view', 'download', 'like'), 'subtitle' => __('选择文章列表Metas的显示。', 'salong')), array('id' => 'switch_download_cat_order', 'type' => 'switch', 'title' => __('是否显示分类排序', 'salong'), 'subtitle' => __('默认显示，在所有下载与分类列表将显示分类与排序模块。', 'salong'), 'default' => true), array('id' => 'switch_download_prevnext', 'type' => 'switch', 'title' => __('是否显示上下篇', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true)));
            $this->sections[] = array('title' => __('文章类型', 'salong'), 'desc' => __('下载文章类型的相关设置。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_download_type', 'type' => 'switch', 'title' => __('是否显示下载类型文章', 'salong'), 'subtitle' => __('默认显示，关闭则所有下载设置将无效。', 'salong'), 'default' => true), array('id' => 'download_post_slug', 'type' => 'text', 'title' => __('下载链接别名', 'salong'), 'subtitle' => __('输入下载类型文章链接别名，设置后请再保存下固定链接。', 'salong'), 'default' => __('download', 'salong'), 'required' => array('switch_download_type', 'equals', array('1')))));
            $this->sections[] = array('title' => __('相关下载', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_download_related', 'type' => 'switch', 'title' => __('是否显示相关下载', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'download_related_rule', 'type' => 'button_set', 'title' => __('获取规则', 'salong'), 'options' => array('cat' => __('分类', 'salong'), 'tag' => __('标签', 'salong')), 'default' => 'cat', 'subtitle' => __('默认以分类来获取相关文章', 'salong')), array('id' => 'download_related_title', 'type' => 'text', 'title' => __('标题', 'salong'), 'default' => __('相关下载', 'salong'), 'required' => array('switch_download_related', 'equals', array('1'))), array('id' => 'download_related_count', 'type' => 'slider', 'title' => __('数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：3、最大值：24、阶梯值：1、默认值：3。', 'salong'), 'default' => 3, 'min' => 3, 'step' => 1, 'max' => 24, 'display_value' => 'text', 'required' => array('switch_download_related', 'equals', array('1')))));
            $this->sections[] = array('icon' => 'dashicons-video-alt2', 'title' => __('视频', 'salong'), 'fields' => array(array('id' => 'video_metas', 'type' => 'button_set', 'multi' => true, 'title' => __('视频METAS', 'salong'), 'options' => array('author' => __('作者', 'salong'), 'category' => __('分类', 'salong'), 'date' => __('日期', 'salong'), 'view' => __('浏览', 'salong'), 'like' => __('点赞', 'salong'), 'comment' => __('评论', 'salong'), 'time' => __('时间', 'salong')), 'default' => array('author', 'category', 'date', 'view', 'comment', 'time', 'like'), 'subtitle' => __('选择文章列表Metas的显示。', 'salong')), array('id' => 'switch_video_cat_order', 'type' => 'switch', 'title' => __('是否显示分类排序', 'salong'), 'subtitle' => __('默认显示，在所有视频与分类列表将显示分类与排序模块。', 'salong'), 'default' => true), array('id' => 'switch_video_prevnext', 'type' => 'switch', 'title' => __('是否显示上下篇', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true)));
            $this->sections[] = array('title' => __('文章类型', 'salong'), 'desc' => __('视频文章类型的相关设置。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_video_type', 'type' => 'switch', 'title' => __('是否显示视频类型文章', 'salong'), 'subtitle' => __('默认显示，关闭则所有视频设置将无效。', 'salong'), 'default' => true), array('id' => 'video_post_slug', 'type' => 'text', 'title' => __('视频链接别名', 'salong'), 'subtitle' => __('输入视频类型文章链接别名，设置后请再保存下固定链接。', 'salong'), 'default' => __('video', 'salong'), 'required' => array('switch_video_type', 'equals', array('1')))));
            $this->sections[] = array('title' => __('优酷视频', 'salong'), 'subsection' => true, 'subtitle' => __('优酷视频相关设置，主要是直接获取优酷视频的缩略图。', 'salong'), 'fields' => array(array('id' => 'client_youku', 'type' => 'text', 'title' => __('优酷client_id', 'salong'), 'subtitle' => __('输入优酷client_id，请到<a href="http://cloud.youku.com/" target="_blank">优酷视频云</a>中申请。', 'salong'), 'default' => 'ec0d96629b1f9701')));
            $this->sections[] = array('title' => __('阿里云视频点播', 'salong'), 'desc' => __('阿里云视频点播 Access Key 设置', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'access_key_id', 'type' => 'text', 'title' => __('Access Key ID', 'salong'), 'subtitle' => __('请到阿里云个人中心 Access Key 管理控制台查看。', 'salong'), 'default' => ''), array('id' => 'access_key_secret', 'type' => 'text', 'title' => __('Access Key Secret', 'salong'), 'subtitle' => __('请到阿里云个人中心 Access Key 管理控制台查看。', 'salong'), 'default' => '')));
            $this->sections[] = array('title' => __('相关视频', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_video_related', 'type' => 'switch', 'title' => __('是否显示相关视频', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'video_related_rule', 'type' => 'button_set', 'title' => __('获取规则', 'salong'), 'options' => array('cat' => __('分类', 'salong'), 'tag' => __('标签', 'salong')), 'default' => 'cat', 'subtitle' => __('默认以分类来获取相关文章', 'salong')), array('id' => 'video_related_title', 'type' => 'text', 'title' => __('标题', 'salong'), 'default' => __('相关视频', 'salong'), 'required' => array('switch_video_related', 'equals', array('1'))), array('id' => 'video_related_count', 'type' => 'slider', 'title' => __('数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：3、最大值：24、阶梯值：1、默认值：3。', 'salong'), 'default' => 3, 'min' => 3, 'step' => 1, 'max' => 24, 'display_value' => 'text', 'required' => array('switch_video_related', 'equals', array('1')))));
            $this->sections[] = array('icon' => 'dashicons-cart', 'title' => __('商城', 'salong'), 'fields' => array(array('id' => 'product_post_slug', 'type' => 'text', 'title' => __('产品链接别名', 'salong'), 'subtitle' => __('输入产品类型文章链接别名', 'salong'), 'desc' => __('此选项只对开启了『常规——是否启用自定义文章类型伪静态』有效，关闭了此功能，可以设置『设置——固定链接』中的参数来更改产品链接的 slug，设置后请再保存下固定链接。', 'salong'), 'default' => __('product', 'salong')), array('id' => 'product_related_count', 'type' => 'slider', 'title' => __('相关产品数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：4、最大值：24、阶梯值：1、默认值：4', 'salong'), 'default' => 4, 'min' => 4, 'step' => 1, 'max' => 24, 'display_value' => 'text'), array('id' => 'switch_woo_fields', 'type' => 'switch', 'title' => __('是否优化结算等字段', 'salong'), 'subtitle' => __('默认开启', 'salong'), 'default' => true)));
            $this->sections[] = array('title' => __('产品缩略图', 'salong'), 'desc' => __('产品缩略图相关设置', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'product_cateimg_width', 'type' => 'slider', 'title' => __('产品分类缩略图宽度', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：400、最大值：1000、阶梯值：1、默认值：460', 'salong'), 'desc' => __('此侧参数为产品分类与特色图像的宽度，只对使用timthumb.php插件裁剪缩略图有效，对WP自带的缩略图裁剪功能无效。', 'salong'), 'default' => 460, 'min' => 400, 'step' => 1, 'max' => 1000, 'display_value' => 'text', 'required' => array('thumb_mode', 'equals', array('timthumb'))), array('id' => 'product_cateimg_height', 'type' => 'slider', 'title' => __('产品分类缩略图高度', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：200、最大值：1000、阶梯值：1、默认值：280', 'salong'), 'desc' => __('此侧参数为产品分类与特色图像的高度，只对使用timthumb.php插件裁剪缩略图有效，对WP自带的缩略图裁剪功能无效。', 'salong'), 'default' => 280, 'min' => 200, 'step' => 1, 'max' => 1000, 'display_value' => 'text', 'required' => array('thumb_mode', 'equals', array('timthumb'))), array('id' => 'product_gallery_width', 'type' => 'slider', 'title' => __('产品画廊与小工具缩略图宽度', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：72、最大值：600、阶梯值：1、默认值：120', 'salong'), 'desc' => __('此侧参数为产品画廊与小工具缩略图的宽度，只对使用timthumb.php插件裁剪缩略图有效，对WP自带的缩略图裁剪功能无效。', 'salong'), 'default' => 120, 'min' => 72, 'step' => 1, 'max' => 600, 'display_value' => 'text', 'required' => array('thumb_mode', 'equals', array('timthumb'))), array('id' => 'product_gallery_height', 'type' => 'slider', 'title' => __('产品画廊与小工具缩略图高度', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：45、最大值：600、阶梯值：1、默认值：72', 'salong'), 'desc' => __('此侧参数为产品画廊与小工具缩略图的高度，只对使用timthumb.php插件裁剪缩略图有效，对WP自带的缩略图裁剪功能无效。', 'salong'), 'default' => 72, 'min' => 45, 'step' => 1, 'max' => 600, 'display_value' => 'text', 'required' => array('thumb_mode', 'equals', array('timthumb')))));
            $this->sections[] = array('title' => __('筛选信息', 'salong'), 'desc' => __('产品筛选功能需要增加其它字段，需要定制，请联系我们。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'sift_price', 'type' => 'textarea', 'title' => __('价格区间', 'salong'), 'subtitle' => __('输入价格区间，格式：p1=0-199，一行一个。', 'salong'), 'default' => 'p1=0-199
p2=200-499
p3=500-999
p4=1000以上'), array('id' => 'sift_paixu', 'type' => 'textarea', 'title' => __('排序', 'salong'), 'subtitle' => __('参数可以删除，但不能增加。', 'salong'), 'default' => 'popularity=销量
view=浏览量
like=点赞量
rating=好评度
rand=随机显示
price=价格从低到高
price-desc=价格从高到低')));
            $this->sections[] = array('icon' => 'dashicons-admin-page', 'title' => __('页面', 'salong'), 'fields' => array(array('id' => 'salong_install_page', 'type' => 'switch', 'title' => __('创建默认页面', 'salong'), 'subtitle' => __('默认启用，在启用主题后会自动创建主题提供的一此页面。', 'salong'), 'desc' => __('请不要修改这些默认页面的别名，如果页面删除或者修改了别名，请先关闭此选项，不然每次启用主题都会再创建没有的页面。', 'salong'), 'default' => true)));
            $this->sections[] = array('title' => __('404页面', 'salong'), 'desc' => __('404页面相关设置', 'salong'), 'subsection' => true, 'fields' => array(array('id' => '404_title', 'type' => 'text', 'title' => __('标题', 'salong'), 'subtitle' => __('输入404页面标题', 'salong'), 'default' => __('404 :(', 'salong')), array('id' => '404_desc', 'type' => 'text', 'title' => __('描述', 'salong'), 'subtitle' => __('输入404页面描述', 'salong'), 'default' => __('没有找到相关内容，请访问其它页面或返回首页！', 'salong')), array('id' => '404_img', 'type' => 'media', 'url' => true, 'title' => __('404图片', 'salong'), 'compiler' => true, 'readonly' => false, 'subtitle' => __('更新404图片，宽度最小为 600，高度不限。', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/images/404.jpg'))));
            $this->sections[] = array('title' => __('所有用户', 'salong'), 'desc' => __('所有用户相关设置', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'all_user_page', 'type' => 'select', 'data' => 'pages', 'title' => __('所有用户页面', 'salong'), 'subtitle' => __('选择所有用户页面。', 'salong')), array('id' => 'all_user_count', 'type' => 'slider', 'title' => __('显示数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：1、最大值：1000、阶梯值：1、默认值：12', 'salong'), 'default' => 12, 'min' => 1, 'step' => 1, 'max' => 1000, 'display_value' => 'text'), array('id' => 'recommend_user', 'type' => 'select', 'data' => 'users', 'args' => array('number' => 50, 'orderby' => 'post_count', 'order' => 'DESC'), 'multi' => true, 'sortable' => true, 'title' => __('推荐用户', 'salong'), 'subtitle' => __('选择推荐用户，后台默认获取前50位用户，按文章数量进行排序。', 'salong'))));
            $this->sections[] = array('title' => __('客户留言', 'salong'), 'desc' => __('客户留言相关设置', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'message_count', 'type' => 'slider', 'title' => __('读者墙显示数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：5、最大值：1000、阶梯值：1、默认值：30', 'salong'), 'default' => 30, 'min' => 5, 'step' => 1, 'max' => 1000, 'display_value' => 'text'), array('id' => 'exclude_email', 'type' => 'text', 'title' => __('排除留言Email', 'salong'), 'subtitle' => __('输入在读者墙中需要排除的留言Email，这里只能输入一个Email，管理员的或你最不想看的人的Email。', 'salong'))));
            $this->sections[] = array('title' => __('友情链接', 'salong'), 'desc' => __('友情链接相关设置', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_link_icon', 'type' => 'switch', 'title' => __('是否显示友情链接图标', 'salong'), 'subtitle' => __('默认显示，获取图标的功能是使用第三方的链接，如果不显示图标，请关闭。', 'salong'), 'default' => true), array('id' => 'link_category_orderby', 'type' => 'select', 'title' => __('链接分类排序', 'salong'), 'subtitle' => __('链接分类的排列顺序，可选择以下几种，默认按发布日期', 'salong'), 'options' => array('name' => __('标题', 'salong'), 'id' => 'ID', 'slug' => __('别名', 'salong'), 'count' => __('数量', 'salong')), 'default' => 'name'), array('id' => 'link_category_order', 'type' => 'select', 'title' => __('链接分类升序或降序', 'salong'), 'subtitle' => __('链接分类的升序或降序，默认升序', 'salong'), 'options' => array('asc' => __('升序', 'salong'), 'desc' => __('降序', 'salong')), 'default' => 'desc'), array('id' => 'exclude_link_category', 'type' => 'select', 'data' => 'categories', 'args' => array('taxonomy' => array('link_category')), 'multi' => true, 'sortable' => true, 'title' => __('排除链接分类', 'salong'), 'subtitle' => __('选择需要排除的链接分类，不选则显示全部链接分类，排除全部分类将显示所有分类书签。', 'salong')), array('id' => 'link_orderby', 'type' => 'select', 'title' => __('链接排序', 'salong'), 'subtitle' => __('链接的排列顺序，可选择以下几种，默认随机', 'salong'), 'options' => array('rand' => __('随机', 'salong'), 'name' => __('标题', 'salong'), 'link_id' => 'ID', 'target' => __('目标', 'salong'), 'description' => __('描述', 'salong'), 'rating' => __('等级', 'salong'), 'updated' => __('更新', 'salong'), 'rel' => __('链接关系', 'salong'), 'notes' => __('注释', 'salong'), 'rss' => 'RSS', 'length' => __('名称长度', 'salong')), 'default' => 'rand'), array('id' => 'link_order', 'type' => 'select', 'title' => __('链接升序或降序', 'salong'), 'subtitle' => __('链接的升序或降序，默认升序', 'salong'), 'options' => array('asc' => __('升序', 'salong'), 'desc' => __('降序', 'salong')), 'default' => 'desc'), array('id' => 'exclude_link', 'type' => 'text', 'title' => __('排除链接', 'salong'), 'subtitle' => __('输入需要排除的友情链接，格式：1,2,3（后台不能获取友情链接，所以需要前往友情链接中查看链接的ID)', 'salong'))));
            $this->sections[] = array('title' => __('站点地图', 'salong'), 'desc' => __('站点地图相关设置', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'sitemap_post_count', 'type' => 'slider', 'title' => __('文章最大显示数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，-1为不限制文章显示的数量，滑块说明：最小值：-1、最大值：1000、阶梯值：1、默认值：10', 'salong'), 'default' => 10, 'min' => -1, 'step' => 1, 'max' => 1000, 'display_value' => 'text'), array('id' => 'sitemap_tag_count', 'type' => 'slider', 'title' => __('标签最大显示数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：1、最大值：1000、阶梯值：1、默认值：10', 'salong'), 'default' => 10, 'min' => 1, 'step' => 1, 'max' => 1000, 'display_value' => 'text')));
            $this->sections[] = array('icon' => 'dashicons-location', 'title' => __('面包屑', 'salong'), 'fields' => array(array('id' => 'switch_crumbs', 'type' => 'switch', 'title' => __('是否显示面包屑', 'salong'), 'subtitle' => __('默认显示，关闭则全站不显示面包屑。', 'salong'), 'default' => true), array('id' => 'delimiter', 'type' => 'text', 'title' => __('定界符', 'salong'), 'subtitle' => __('输入面包屑定界符', 'salong'), 'default' => '-', 'required' => array('switch_crumbs', 'equals', array('1')))));
            $this->sections[] = array('title' => __('所有文章', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'post_bg', 'type' => 'media', 'url' => true, 'title' => __('背景图片', 'salong'), 'compiler' => true, 'readonly' => false, 'subtitle' => __('更新所有文章背景图片，建议大小：1920*300。', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/img-post.jpg')), array('id' => 'post_desc', 'type' => 'editor', 'title' => __('描述', 'salong'), 'subtitle' => __('输入所有文章描述', 'salong'), 'default' => __('MNews 主题站精选优质文章，丰富您的阅读。', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'post_bg_rgba', 'type' => 'color_rgba', 'title' => __('背景明暗度', 'salong'), 'subtitle' => __('所有文章页面背景明暗度', 'salong'), 'default' => array('color' => '#000', 'alpha' => '.3'), 'mode' => 'background')));
            $this->sections[] = array('title' => __('所有专题', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'topic_bg', 'type' => 'media', 'url' => true, 'title' => __('背景图片', 'salong'), 'compiler' => true, 'readonly' => false, 'subtitle' => __('更新所有专题背景图片，建议大小：1920*300。', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/img-topic.jpg')), array('id' => 'topic_desc', 'type' => 'editor', 'title' => __('描述', 'salong'), 'subtitle' => __('输入所有专题描述', 'salong'), 'default' => __('从产品设计、需求分析、用户调研、职场攻略、产品运营、数据分析、市场分析、沟通技巧、项目管理、学习书单10个维度为你打造学习天地。', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'topic_bg_rgba', 'type' => 'color_rgba', 'title' => __('背景明暗度', 'salong'), 'subtitle' => __('所有专题页面背景明暗度', 'salong'), 'default' => array('color' => '#000', 'alpha' => '.3'), 'mode' => 'background')));
            $this->sections[] = array('title' => __('所有下载', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'download_bg', 'type' => 'media', 'url' => true, 'title' => __('背景图片', 'salong'), 'compiler' => true, 'readonly' => false, 'subtitle' => __('更新所有下载背景图片，建议大小：1920*300。', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/img-download.jpg')), array('id' => 'download_desc', 'type' => 'editor', 'title' => __('描述', 'salong'), 'subtitle' => __('输入所有下载描述', 'salong'), 'default' => __('善其事必先利器，为你贴心提供必备的软件下载，助你专业技能快速提升。', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'download_bg_rgba', 'type' => 'color_rgba', 'title' => __('背景明暗度', 'salong'), 'subtitle' => __('所有下载页面背景明暗度', 'salong'), 'default' => array('color' => '#000', 'alpha' => '.3'), 'mode' => 'background')));
            $this->sections[] = array('title' => __('所有视频', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'video_bg', 'type' => 'media', 'url' => true, 'title' => __('背景图片', 'salong'), 'compiler' => true, 'readonly' => false, 'subtitle' => __('更新所有视频背景图片，建议大小：1920*300。', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/img-video.jpg')), array('id' => 'video_desc', 'type' => 'editor', 'title' => __('描述', 'salong'), 'subtitle' => __('输入所有视频描述', 'salong'), 'default' => __('精选优质视频，皮克斯优秀动画短片，BBS 优秀纪录片，丰富您的视听体验。', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'video_bg_rgba', 'type' => 'color_rgba', 'title' => __('背景明暗度', 'salong'), 'subtitle' => __('所有视频页面背景明暗度', 'salong'), 'default' => array('color' => '#000', 'alpha' => '.3'), 'mode' => 'background')));
            $this->sections[] = array('title' => __('所有快讯', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'kx_bg', 'type' => 'media', 'url' => true, 'title' => __('背景图片', 'salong'), 'compiler' => true, 'readonly' => false, 'subtitle' => __('更新所有快讯背景图片，建议大小：1920*300。', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/img-kx.jpg')), array('id' => 'kx_desc', 'type' => 'editor', 'title' => __('描述', 'salong'), 'subtitle' => __('输入所有快讯描述', 'salong'), 'default' => __('精选优质快讯，让读者第一时间了解当下互联网的大事件。', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'kx_bg_rgba', 'type' => 'color_rgba', 'title' => __('背景明暗度', 'salong'), 'subtitle' => __('所有快讯页面背景明暗度', 'salong'), 'default' => array('color' => '#000', 'alpha' => '.3'), 'mode' => 'background')));
            $this->sections[] = array('title' => __('所有产品', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'product_bg', 'type' => 'media', 'url' => true, 'title' => __('背景图片', 'salong'), 'compiler' => true, 'readonly' => false, 'subtitle' => __('更新所有产品背景图片，建议大小：1920*300。', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/img-product.jpg')), array('id' => 'product_desc', 'type' => 'editor', 'title' => __('描述', 'salong'), 'subtitle' => __('输入所有产品描述', 'salong'), 'default' => __('萨龙网络原创精致 WordPress 主题，设计简约、大气，功能强大、实用。', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'product_bg_rgba', 'type' => 'color_rgba', 'title' => __('背景明暗度', 'salong'), 'subtitle' => __('所有产品页面背景明暗度', 'salong'), 'default' => array('color' => '#000', 'alpha' => '.3'), 'mode' => 'background')));
            $this->sections[] = array('title' => __('用户中心', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'author_bg', 'type' => 'media', 'url' => true, 'title' => __('背景图片', 'salong'), 'compiler' => true, 'readonly' => false, 'subtitle' => __('更新用户中心背景图片，建议大小：1920*300。', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/img-author.jpg')), array('id' => 'author_bg_rgba', 'type' => 'color_rgba', 'title' => __('背景明暗度', 'salong'), 'subtitle' => __('用户中心页面背景明暗度', 'salong'), 'default' => array('color' => '#000', 'alpha' => '.3'), 'mode' => 'background')));
            $this->sections[] = array('icon' => 'dashicons-admin-settings', 'title' => __('边栏', 'salong'), 'fields' => array(array('id' => 'sidebars', 'type' => 'multi_text', 'title' => __('小工具', 'salong'), 'subtitle' => __('默认边栏（首页,博客,默认文章,专题文章,下载文章,移动）请不要删除，可增加新的边栏。', 'salong'), 'default' => array(__('首页', 'salong'), __('博客', 'salong'), __('默认文章', 'salong'), __('专题文章', 'salong'), __('下载文章', 'salong'), __('视频文章', 'salong'), __('产品文章', 'salong'), __('移动', 'salong'), __('快讯', 'salong')))));
            $this->sections[] = array('title' => __('作者小工具', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_author_post', 'type' => 'switch', 'title' => __('文章中是否显示作者小工具', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'switch_author_topic', 'type' => 'switch', 'title' => __('专题中是否显示作者小工具', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'switch_author_download', 'type' => 'switch', 'title' => __('下载中是否显示作者小工具', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'switch_author_video', 'type' => 'switch', 'title' => __('视频中是否显示作者小工具', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'author_post_count', 'type' => 'slider', 'title' => __('文章数量', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：1、最大值：100、阶梯值：1、默认值：5。', 'salong'), 'default' => 5, 'min' => 1, 'step' => 1, 'max' => 100, 'display_value' => 'text'), array('id' => 'author_img', 'type' => 'media', 'url' => true, 'title' => __('作者头像背景图片', 'salong'), 'compiler' => true, 'readonly' => false, 'subtitle' => __('更新作者头像背景图片，建议大小：380*120。', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/author-img.jpg'))));
            $this->sections[] = array('title' => 'SMTP', 'icon' => 'dashicons-email-alt', 'fields' => array(array('id' => 'switch_smtp', 'type' => 'switch', 'title' => __('是否显示SMTP邮件发送', 'salong'), 'subtitle' => __('默认显示', 'salong'), 'default' => true), array('id' => 'smtp_name', 'type' => 'text', 'title' => __('发件人昵称', 'salong'), 'subtitle' => __('输入SMTP发件人昵称', 'salong'), 'default' => __('大理萨龙网络', 'salong'), 'required' => array('switch_smtp', 'equals', array('1'))), array('id' => 'smtp_username', 'type' => 'text', 'title' => __('认证用户名', 'salong'), 'subtitle' => __('输入SMTP认证用户名(完整邮件地址)', 'salong'), 'default' => 'admin@salongweb.com', 'required' => array('switch_smtp', 'equals', array('1'))), array('id' => 'smtp_password', 'type' => 'text', 'title' => __('认证密码', 'salong'), 'subtitle' => __('输入SMTP认证密码(登录邮箱的密码)', 'salong'), 'default' => '', 'required' => array('switch_smtp', 'equals', array('1'))), array('id' => 'smtp_host', 'type' => 'text', 'title' => __('服务器地址', 'salong'), 'subtitle' => __('输入SMTP服务器地址', 'salong'), 'default' => 'smtp.ym.163.com', 'required' => array('switch_smtp', 'equals', array('1'))), array('id' => 'smtp_port', 'type' => 'text', 'title' => __('服务器端口', 'salong'), 'subtitle' => __('输入SMTP服务器端口，一般默认25，启用SSL一般为465', 'salong'), 'default' => '25', 'required' => array('switch_smtp', 'equals', array('1'))), array('id' => 'switch_secure', 'type' => 'switch', 'title' => __('是否启用SSL', 'salong'), 'subtitle' => __('默认禁用，启用后请设置服务器端口为465。', 'salong'), 'default' => false, 'required' => array('switch_smtp', 'equals', array('1')))));
            $this->sections[] = array('icon' => 'dashicons-admin-tools', 'title' => __('优化', 'salong'), 'fields' => array(array('id' => 'switch_authors_autocomplete', 'type' => 'switch', 'title' => __('编辑文章搜索作者', 'salong'), 'subtitle' => __('默认启用，后台编辑文章中的作者模块可 ajax 搜索。', 'salong'), 'default' => true), array('id' => 'switch_filter_time', 'type' => 'switch', 'title' => __('格式化日期', 'salong'), 'subtitle' => __('默认启用，日期将被格式化，比如：1天前。', 'salong'), 'default' => true), array('id' => 'switch_filter_count', 'type' => 'switch', 'title' => __('格式化数字', 'salong'), 'subtitle' => __('默认启用，相关数字将被格式化，比如：1680，将被格式化为 1.68K。', 'salong'), 'default' => true), array('id' => 'switch_link_go', 'type' => 'switch', 'title' => __('外链跳转', 'salong'), 'subtitle' => __('默认启用，外部链接添加自动跳转，包括评论者链接。', 'salong'), 'default' => true), array('id' => 'switch_new_open_link', 'type' => 'switch', 'title' => __('链接新窗口打开', 'salong'), 'subtitle' => __('默认启用', 'salong'), 'default' => true), array('id' => 'switch_upload_path', 'type' => 'switch', 'title' => __('显示上传设置', 'salong'), 'subtitle' => __('默认启用，在设置——多媒体中设置路径', 'salong'), 'default' => true), array('id' => 'remove_category_slug', 'type' => 'switch', 'title' => __('移除category分类标记', 'salong'), 'subtitle' => __('默认启用，将移除category分类标记', 'salong'), 'default' => true), array('id' => 'switch_redirect_single_post', 'type' => 'switch', 'title' => __('搜索重定向到日志', 'salong'), 'subtitle' => __('默认启用，当搜索结果只有一篇时直接重定向到日志。', 'salong'), 'default' => true), array('id' => 'switch_search_by_title_only', 'type' => 'switch', 'title' => __('只搜索文章标题', 'salong'), 'subtitle' => __('默认启用，关键字搜索只匹配标题。', 'salong'), 'default' => true), array('id' => 'switch_useradd_time', 'type' => 'switch', 'title' => __('后台用户列表中显示注册时间', 'salong'), 'subtitle' => __('默认启用', 'salong'), 'default' => true), array('id' => 'switch_remove_user_contactmethods', 'type' => 'switch', 'title' => __('移除不必要的用户联系信息', 'salong'), 'subtitle' => __('默认启用', 'salong'), 'default' => true), array('id' => 'switch_max_srcset', 'type' => 'switch', 'title' => __('禁用WP响应式图片功能', 'salong'), 'subtitle' => __('默认启用', 'salong'), 'default' => true), array('id' => 'switch_pingback', 'type' => 'switch', 'title' => __('禁用站内PingBack', 'salong'), 'subtitle' => __('默认启用，增加网站安全性与速度。', 'salong'), 'default' => true), array('id' => 'switch_header_code', 'type' => 'switch', 'title' => __('禁用头部冗余代码', 'salong'), 'subtitle' => __('默认启用，将移除头部无关紧要的代码，保证代码的干净，提高效率及安全性。', 'salong'), 'default' => true), array('id' => 'switch_feed', 'type' => 'switch', 'title' => __('禁用RSS Feed', 'salong'), 'subtitle' => __('禁用RSS Feed防止rss采集', 'salong'), 'default' => true), array('id' => 'switch_capital_P_dangit', 'type' => 'switch', 'title' => __('禁用WordPress大小写函数', 'salong'), 'subtitle' => __("默认启用，禁止自动把'Wordpress'之类的变成'WordPress'。", 'salong'), 'default' => true), array('id' => 'switch_rest_api', 'type' => 'switch', 'title' => __('禁用REST API', 'salong'), 'subtitle' => __('默认启用，一般用不上。', 'salong'), 'default' => true), array('id' => 'switch_post_revision', 'type' => 'switch', 'title' => __('禁用日志修订功能', 'salong'), 'subtitle' => __('默认启用', 'salong'), 'default' => true), array('id' => 'switch_autosave', 'type' => 'switch', 'title' => __('禁用文章自动保存', 'salong'), 'subtitle' => __('默认启用', 'salong'), 'default' => true), array('id' => 'switch_recently_active_plugins', 'type' => 'switch', 'title' => __('禁止显示最近启用过的插件', 'salong'), 'subtitle' => __('默认启用', 'salong'), 'default' => true), array('id' => 'switch_dashboard_widgets', 'type' => 'switch', 'title' => __('移除仪表盘小工具', 'salong'), 'subtitle' => __('默认启用', 'salong'), 'default' => true), array('id' => 'switch_staticize_emoji', 'type' => 'switch', 'title' => __('禁止Emoji表情', 'salong'), 'subtitle' => __('默认启用，提高网站加载速度', 'salong'), 'default' => true), array('id' => 'switch_wp_cron', 'type' => 'switch', 'title' => __('禁用文章定时发布功能', 'salong'), 'subtitle' => __('默认启用，如果网站不需要定时发布功能可以启用。', 'salong'), 'default' => true), array('id' => 'switch_xmlrpc_enabled', 'type' => 'switch', 'title' => __('禁用XML-RPC接口', 'salong'), 'subtitle' => __('默认启用，如果网站无需通过APP客户端发布日志，离线发布功能就启用。', 'salong'), 'default' => true), array('id' => 'switch_admin_color_schemes', 'type' => 'switch', 'title' => __('移除管理界面配色方案', 'salong'), 'subtitle' => __('默认启用，我的个人资料中的配色将不显示。', 'salong'), 'default' => true), array('id' => 'switch_login_errors', 'type' => 'switch', 'title' => __('移除登陆错误提示', 'salong'), 'subtitle' => __('默认启用，登录错误将不提示，有利于网站安全。', 'salong'), 'default' => true), array('id' => 'switch_remove_logo', 'type' => 'switch', 'title' => __('移除工具栏上WordPress LOGO', 'salong'), 'subtitle' => __('默认启用，将移除LOGO', 'salong'), 'default' => true), array('id' => 'switch_shortcode_auto', 'type' => 'switch', 'title' => __('禁止简码自动添加p与br标签', 'salong'), 'subtitle' => __('默认启用，将移除简码中的p与br标签', 'salong'), 'default' => true), array('id' => 'switch_shortcode_unautop', 'type' => 'switch', 'title' => __('Shortcode优先于wpautop执行', 'salong'), 'subtitle' => __('默认禁用，简码将优于wpautop执行，启用后 Wechat login 插件的有些功能会有问题。', 'salong'), 'default' => false), array('id' => 'switch_minify_html', 'type' => 'switch', 'title' => __('html 代码压缩输出', 'salong'), 'subtitle' => __('默认启用', 'salong'), 'default' => false), array('id' => 'switch_copy', 'type' => 'switch', 'title' => __('禁止复制内容', 'salong'), 'subtitle' => __('默认禁用，启用前台页面将不能选择和复制内容，同时禁止鼠标右键', 'salong'), 'default' => false), array('id' => 'switch_content_auto', 'type' => 'switch', 'title' => __('禁止整个文章自动添加p与br标签', 'salong'), 'subtitle' => __('默认禁用，启用将移除整个文章内容中的p与br标签，该项包括上一项的功能，所以启用该项就关闭上一项。', 'salong'), 'default' => false), array('id' => 'switch_date_default', 'type' => 'switch', 'title' => __('重置系统时间为北京时间', 'salong'), 'subtitle' => __('默认禁用，如果与系统时间相关8小时请启用。', 'salong'), 'default' => false), array('id' => 'switch_update_core', 'type' => 'switch', 'title' => __('后台更新提示', 'salong'), 'subtitle' => __('默认禁用，启用将移除后台核心，插件和主题的更新提示。', 'salong'), 'default' => false), array('id' => 'switch_wp_oembed', 'type' => 'switch', 'title' => __('文章Embed功能', 'salong'), 'subtitle' => __('默认禁用，启用后视频或其它链接将不会进行转换。', 'salong'), 'default' => false), array('id' => 'switch_weihu', 'type' => 'switch', 'title' => __('网站维护功能', 'salong'), 'subtitle' => __('默认禁用', 'salong'), 'default' => false)));
            $this->sections[] = array('title' => __('登录地址', 'salong'), 'desc' => __('重定义登录地址，链接地址默认为：http://yourdomain.com/wp-login.php?word=press，域名已经自动获取站点域名，需要修改“word”和“press”两个值，修改后要牢记了。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_admin_link', 'type' => 'switch', 'title' => __('是否自定义登录地址', 'salong'), 'subtitle' => __('默认禁用', 'salong'), 'default' => false), array('id' => 'admin_word', 'type' => 'text', 'title' => __('第一个值', 'salong'), 'subtitle' => __('重新设置“word”值', 'salong'), 'default' => 'word', 'required' => array('switch_admin_link', 'equals', array('1'))), array('id' => 'admin_press', 'type' => 'text', 'title' => __('第二个值', 'salong'), 'subtitle' => __('重新设置“press”值', 'salong'), 'default' => 'press', 'required' => array('switch_admin_link', 'equals', array('1')))));
            $this->sections[] = array('title' => __('站长验证', 'salong'), 'desc' => __('在站长工具中添加网站时，选择HTML标记验证，代码类似：<meta name="google-site-verification" content="KEY" / >，KEY就是需要输入的值，不输出这不显示此段代码。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'google_key', 'type' => 'text', 'title' => __('谷歌站长工具', 'salong'), 'subtitle' => __('输入HTML标记中的KEY', 'salong'), 'default' => ''), array('id' => 'baidu_key', 'type' => 'text', 'title' => __('百度站长工具', 'salong'), 'subtitle' => __('输入HTML标记中的KEY', 'salong'), 'default' => ''), array('id' => '360_key', 'type' => 'text', 'title' => __('360站长工具', 'salong'), 'subtitle' => __('输入HTML标记中的KEY', 'salong'), 'default' => '')));
            $this->sections[] = array('title' => __('百度推送', 'salong'), 'desc' => __('主动推送文章到百度的相关设置。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_baidu_submit', 'type' => 'switch', 'title' => __('是否启用百度主动推送', 'salong'), 'subtitle' => __('默认禁用', 'salong'), 'default' => false), array('id' => 'baidu_post_type', 'type' => 'select', 'data' => 'post_type', 'multi' => true, 'sortable' => true, 'title' => __('文章类型支持', 'salong'), 'subtitle' => __('选择哪些文章类型发布时主动推送到百度。', 'salong'), 'default' => '', 'required' => array('switch_baidu_submit', 'equals', array('1'))),  array('id' => 'web_token', 'type' => 'text', 'title' => __('token 值', 'salong'), 'subtitle' => __('输入百度主动推送网站 token 值。', 'salong'), 'default' => '', 'required' => array('switch_baidu_submit', 'equals', array('1')))));
            $this->sections[] = array('title' => __('熊掌号粉丝关注', 'salong'), 'desc' => __('熊掌号粉丝关注的相关设置。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_xiongzhang', 'type' => 'switch', 'title' => __('是否启用文章底部熊掌号', 'salong'), 'subtitle' => __('默认启用', 'salong'), 'default' => true), array('id' => 'xiongzhang_post_type', 'type' => 'select', 'data' => 'post_type', 'multi' => true, 'sortable' => true, 'title' => __('文章类型支持', 'salong'), 'subtitle' => __('选择要在哪些文章类型中显示熊掌号。', 'salong'), 'default' => '', 'required' => array('switch_xiongzhang', 'equals', array('1'))),  array('id' => 'xiongzhang_id', 'type' => 'text', 'title' => __('熊掌号 APPID', 'salong'), 'subtitle' => __('输入熊掌号 APPID。', 'salong'), 'desc' => __('请前往『百度搜索资源平台-熊掌号-API提交-推送接口 > 接口调用地址』中获取。', 'salong'), 'default' => '', 'required' => array('switch_xiongzhang', 'equals', array('1'))), array('id' => 'switch_xiongzhang_submit', 'type' => 'switch', 'title' => __('是否启用熊掌号推送', 'salong'), 'subtitle' => __('默认禁用', 'salong'), 'desc' => __('启用后请前往『设置——熊掌号推送』中设置，发布文章时可将文件推送到熊掌号。', 'salong'), 'default' => false)));
            $this->sections[] = array('title' => __('禁止冒充管理员评论', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'switch_incoming_comment', 'type' => 'switch', 'title' => __('禁止冒充管理员评论', 'salong'), 'subtitle' => __('默认启用', 'salong'), 'default' => true), array('id' => 'admin_email', 'type' => 'text', 'title' => __('管理员邮箱', 'salong'), 'subtitle' => __('输入管理员邮箱，防止小人冒充管理员进行评论', 'salong'), 'default' => 'admin@salongweb.com', 'required' => array('switch_incoming_comment', 'equals', array('1')))));
            $this->sections[] = array('icon' => 'dashicons-controls-volumeon', 'title' => '广告', 'fields' => array());
            $this->sections[] = array('title' => __('首页最新文章', 'salong'), 'desc' => __('输入任意联盟广告和自定义广告的代码，为空则不显示任何广告内容，对 ajax 分类筛选功能无效。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'ad_home_new_flow', 'type' => 'editor', 'title' => __('最新文章列表流广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="文章列表上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3)), array('id' => 'ad_home_new_flow_show_count', 'type' => 'slider', 'title' => __('在第几篇文章后显示广告', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：0、最大值：48、阶梯值：1、默认值：3。', 'salong'), 'default' => 3, 'min' => 0, 'step' => 1, 'max' => 48, 'display_value' => 'text')));
            $this->sections[] = array('title' => __('文章页面', 'salong'), 'desc' => __('输入任意联盟广告和自定义广告的代码，为空则不显示任何广告内容。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'ad_post_list', 'type' => 'editor', 'title' => __('文章列表上的广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="文章列表上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3)), array('id' => 'ad_post_single', 'type' => 'editor', 'title' => __('文章内容上的广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="文章内容上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3)), array('id' => 'ad_post_related', 'type' => 'editor', 'title' => __('相关文章上的广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="相关文章上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3)), array('id' => 'ad_post_indent', 'type' => 'section', 'indent' => true, 'title' => __('文章列表流广告', 'salong'), 'subtitle' => __('除首页最新文章外的文章列表页面都将显示该广告。', 'salong')), array('id' => 'ad_post_flow', 'type' => 'editor', 'title' => __('最新文章列表流广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="文章列表上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3)), array('id' => 'ad_post_flow_show_count', 'type' => 'slider', 'title' => __('在第几篇文章后显示广告', 'salong'), 'subtitle' => __('输入数值或拖动滑块，滑块说明：最小值：0、最大值：48、阶梯值：1、默认值：3。', 'salong'), 'default' => 3, 'min' => 0, 'step' => 1, 'max' => 48, 'display_value' => 'text')));
            $this->sections[] = array('title' => __('专题页面', 'salong'), 'desc' => __('输入任意联盟广告和自定义广告的代码，为空则不显示任何广告内容。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'ad_topic_list', 'type' => 'editor', 'title' => __('专题文章列表上的广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="专题文章列表上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3)), array('id' => 'ad_topic_single', 'type' => 'editor', 'title' => __('专题文章内容上的广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="专题文章内容上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3)), array('id' => 'ad_topic_related', 'type' => 'editor', 'title' => __('相关专题上的广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="相关专题上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3))));
            $this->sections[] = array('title' => __('下载页面', 'salong'), 'desc' => __('输入任意联盟广告和自定义广告的代码，为空则不显示任何广告内容。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'ad_download_list', 'type' => 'editor', 'title' => __('下载文章列表上的广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="下载文章列表上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3)), array('id' => 'ad_download_single', 'type' => 'editor', 'title' => __('下载文章内容上的广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="下载文章内容上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3)), array('id' => 'ad_download_related', 'type' => 'editor', 'title' => __('相关下载上的广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="相关下载上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3))));
            $this->sections[] = array('title' => __('视频页面', 'salong'), 'desc' => __('输入任意联盟广告和自定义广告的代码，为空则不显示任何广告内容。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'ad_video_list', 'type' => 'editor', 'title' => __('视频文章列表上的广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="视频文章列表上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3)), array('id' => 'ad_video_single', 'type' => 'editor', 'title' => __('视频文章内容上的广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="视频文章内容上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3)), array('id' => 'ad_video_related', 'type' => 'editor', 'title' => __('相关视频上的广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="相关视频上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3))));
            $this->sections[] = array('title' => __('产品页面', 'salong'), 'desc' => __('输入任意联盟广告和自定义广告的代码，为空则不显示任何广告内容。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'ad_product_list', 'type' => 'editor', 'title' => __('产品文章列表上的广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="产品文章列表上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3)), array('id' => 'ad_product_single', 'type' => 'editor', 'title' => __('产品文章内容上的广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="产品文章内容上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3)), array('id' => 'ad_product_related', 'type' => 'editor', 'title' => __('相关产品上的广告', 'salong'), 'subtitle' => __('输入任意联盟广告和自定义广告的代码', 'salong'), 'default' => __('<a href="https://salongweb.com" title="相关产品上的广告" target="_blank"><img src="https://demo.salongweb.com/mnews/ad.jpg" alt="' . get_bloginfo('name') . '"></a>', 'salong'), 'args' => array('media_buttons' => true, 'textarea_rows' => 3))));
            $this->sections[] = array('icon' => 'dashicons-welcome-view-site', 'title' => 'SEO', 'fields' => array(array('id' => 'switch_seo', 'type' => 'switch', 'title' => __('是否启用SEO', 'salong'), 'subtitle' => __('默认启用，主题各个页面的SEO已经设计好，如果你觉得插件更好用，请禁用此功能。', 'salong'), 'default' => true), array('id' => 'description', 'type' => 'textarea', 'title' => __('博客描述', 'salong'), 'subtitle' => __('输入博客描述', 'salong'), 'default' => '专注高端网站设计与开发，为您提供一个现代、干净的WEB站点！', 'required' => array('switch_seo', 'equals', '1')), array('id' => 'keywords', 'type' => 'textarea', 'title' => __('博客关键词', 'salong'), 'subtitle' => __('输入关键字描述', 'salong'), 'default' => '高端网站建设,大理网站建设,企业电子商城网站,客栈房间预订系统,主机租用,网站托管,Wordpress主题设计开发,Wordpress商城主题,Wordpress网站建设,简约设计,现代干净的设计', 'required' => array('switch_seo', 'equals', '1'))));
            $this->sections[] = array('icon' => 'dashicons-schedule', 'title' => __('代码', 'salong'), 'fields' => array(array('id' => 'css_code', 'type' => 'ace_editor', 'title' => __('自定义CSS代码', 'salong'), 'subtitle' => __('拷贝你的CSS代码到这里。', 'salong'), 'mode' => 'css', 'theme' => 'monokai', 'default' => ''), array('id' => 'tracking_code', 'type' => 'textarea', 'title' => __('网站统计代码', 'salong'), 'subtitle' => __('粘贴你的谷歌分析（或其他）的跟踪代码在这里（包括<script></script>标签）。这将被添加到你的主题的页脚模板。', 'salong'), 'theme' => 'chrome', 'default' => ''), array('id' => 'map_js', 'type' => 'ace_editor', 'title' => __('高德地图JS代码', 'salong'), 'subtitle' => __('添加简码：[map]到联系页面中。', 'salong'), 'desc' => __('请到<a href="http://lbs.amap.com/console/show/tools" target="_blank">高德地图API</a>中创建地图，再输入高德地图JS代码（<script></script>中的代码）到代码框。之前是使用百度地图，但百度地图需要申请API，而且与主题中的压缩HTML代码有冲突，所以决定用高德地图，还不错。', 'salong'), 'mode' => 'javascript', 'theme' => 'chrome', 'default' => '')));
            $this->sections[] = array('icon' => 'dashicons-carrot', 'title' => __('页脚', 'salong'), 'fields' => array(array('id' => 'footer_logo', 'type' => 'media', 'url' => true, 'title' => __('页脚LOGO图片', 'salong'), 'compiler' => true, 'readonly' => false, 'subtitle' => __('更新你的页脚LOGO图片，最大高度：42px', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/images/footer-logo.png')), array('id' => 'copyright_text', 'type' => 'editor', 'title' => __('版权', 'salong'), 'subtitle' => __('输入页脚版权', 'salong'), 'default' => __('Copyright © 2012-2017 <a href="https://salongweb.com" title="大理市萨龙网络科技有限公司｜专注高端网站设计与开发，为您提供一个现代、干净的WEB站点！">大理市萨龙网络科技有限公司</a>.保留所有权利&nbsp;滇ICP备16003941号-11', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'footer_contact', 'type' => 'editor', 'title' => __('联系信息', 'salong'), 'subtitle' => __('输入页脚联系信息', 'salong'), 'default' => __('客服电话：15911225507  反馈建议：admin@salongweb.com', 'salong'), 'args' => array('media_buttons' => false, 'textarea_rows' => 3)), array('id' => 'mobile_btn_metas', 'type' => 'button_set', 'multi' => true, 'title' => __('移动端底部按钮METAS', 'salong'), 'subtitle' => __('移动端底部按钮设置，最多显示5个，其中『商城、购物车和我的账户』是必须安装 WooCommerce 商城插件才有用。', 'salong'), 'options' => array('home' => __('首页', 'salong'), 'search' => __('搜索', 'salong'), 'post' => __('文章', 'salong'), 'kx' => __('快讯', 'salong'), 'topic' => __('专题', 'salong'), 'download' => __('下载', 'salong'), 'video' => __('视频', 'salong'), 'shop' => __('商城', 'salong'), 'wechat' => __('公众号', 'salong'), 'cart' => __('购物车', 'salong'), 'myaccount' => __('我的帐户', 'salong')), 'default' => array('home', 'search', 'video', 'topic', 'post'), 'subtitle' => __('选择文章Metas的显示。', 'salong'))));
            $this->sections[] = array('title' => __('页脚按钮', 'salong'), 'desc' => __('页脚按钮设置。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'app_android_qr', 'type' => 'media', 'url' => true, 'title' => __('APP 安卓版二维码', 'salong'), 'compiler' => true, 'readonly' => false, 'subtitle' => __('更新 APP 安卓版二维码图片，建议大小：258*258', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/salongweb.png')), array('id' => 'app_apple_qr', 'type' => 'media', 'url' => true, 'title' => __('APP 苹果版二维码', 'salong'), 'compiler' => true, 'readonly' => false, 'subtitle' => __('更新 APP 苹果版二维码图片，建议大小：258*258', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/salongweb.png')), array('id' => 'wechat_qr', 'type' => 'media', 'url' => true, 'compiler' => true, 'readonly' => false, 'title' => __('微信公众号二维码', 'salong'), 'subtitle' => __('更新微信公众号二维码图片，建议大小：258*258', 'salong'), 'default' => array('url' => 'https://demo.salongweb.com/mnews/wechat.jpg')), array('id' => 'weibo_url', 'type' => 'text', 'title' => __('微博主页链接', 'salong'), 'subtitle' => __('输入微博主页链接', 'salong'), 'default' => __('https://salongweb.com', 'salong')), array('id' => 'qqzone_url', 'type' => 'text', 'title' => __('QQ 空间主页链接', 'salong'), 'subtitle' => __('输入QQ 空间主页链接', 'salong'), 'default' => __('https://yfdxs.com', 'salong'))));
            $this->sections[] = array('title' => __('侧边按钮', 'salong'), 'desc' => __('侧边按钮。', 'salong'), 'subsection' => true, 'fields' => array(array('id' => 'side_metas', 'type' => 'button_set', 'multi' => true, 'title' => __('显示选项', 'salong'), 'options' => array('feedback' => __('意见反馈', 'salong'), 'question' => __('提交问题', 'salong'), 'qq' => __('在线咨询', 'salong'), 'gb2big5' => __('简繁切换', 'salong'), 'comment' => __('去评论', 'salong'), 'top' => __('回顶部', 'salong')), 'default' => array('feedback', 'qq', 'gb2big5', 'comment', 'top'), 'subtitle' => __('选择需要显示的侧边按钮', 'salong')), array('id' => 'feedback_page', 'type' => 'select', 'data' => 'pages', 'title' => __('意见反馈页面', 'salong'), 'subtitle' => __('选择意见反馈页面，可选择『客户留言』模板页面，也可以选择其它的。', 'salong')), array('id' => 'question_page', 'type' => 'select', 'data' => 'pages', 'title' => __('提交问题页面', 'salong'), 'subtitle' => __('选择提交问题页面，选择前请确保安装了『DW Question Answer』问答插件。', 'salong')), array('id' => 'qq_num', 'type' => 'text', 'title' => __('QQ 号码', 'salong'), 'subtitle' => __('输入QQ 号码，用户点击按钮可直接 QQ 对话。', 'salong'), 'default' => __('66895271', 'salong'))));
            $this->sections[] = array('type' => 'divide');
            $this->sections[] = array('icon' => 'dashicons-smiley', 'title' => __('主题信息', 'salong'), 'desc' => '<a target="_blank" title="' . __('萨龙网络｜专注高端网站设计与开发，为您提供一个现代、干净的WEB站点！', 'salong') . '" href="https://salongweb.com">' . __('萨龙网络原创主题', 'salong') . '</a>', 'fields' => array(array('id' => 'raw_new_info', 'type' => 'raw', 'content' => $xzv_0)));
        }
        public function setArguments()
        {
            $xzv_3 = wp_get_theme();
            $this->args = array('opt_name' => 'salong', 'display_name' => $xzv_3->get('Name'), 'display_version' => $xzv_3->get('Version'), 'menu_type' => 'menu', 'allow_sub_menu' => true, 'menu_title' => __('主题选项', 'salong'), 'page_title' => __('主题选项', 'salong'), 'google_api_key' => 'AIzaSyBTFiwsbTWfSMvvClQjz192yMJOdIKNMoo', 'async_typography' => false, 'admin_bar' => true, 'global_variable' => 'salong', 'dev_mode' => false, 'update_notice' => false, 'customizer' => true, 'page_priority' => null, 'page_parent' => 'themes.php', 'page_permissions' => 'manage_options', 'menu_icon' => '', 'last_tab' => '', 'page_icon' => 'icon-themes', 'page_slug' => '_options', 'save_defaults' => true, 'default_show' => false, 'default_mark' => '', 'show_import_export' => true, 'transient_time' => 60 * MINUTE_IN_SECONDS, 'output' => true, 'output_tag' => true, 'database' => '', 'system_info' => false, 'hints' => array('icon' => 'icon-question-sign', 'icon_position' => 'right', 'icon_color' => 'lightgray', 'icon_size' => 'normal', 'tip_style' => array('color' => 'light', 'shadow' => true, 'rounded' => false, 'style' => ''), 'tip_position' => array('my' => 'top left', 'at' => 'bottom right'), 'tip_effect' => array('show' => array('effect' => 'slide', 'duration' => '500', 'event' => 'mouseover'), 'hide' => array('effect' => 'slide', 'duration' => '500', 'event' => 'click mouseleave'))));
            if (!isset($this->args['global_variable']) || $this->args['global_variable'] !== false) {
                if (!empty($this->args['global_variable'])) {
                    $xzv_7 = $this->args['global_variable'];
                } else {
                    $xzv_7 = str_replace('-', '_', $this->args['opt_name']);
                }
                $this->args['intro_text'] = sprintf('<p>感谢使用萨龙网络原创主题<strong>' . $xzv_3->display('Name') . '</strong>，更多主题请访问：<a href="https://salongweb.com/shop.html" target="_blank">主题商城</a>，技术支持：<a href="https://salongweb.com/contact.html" target="_blank">联系我们</a></p>');
            } else {
                $this->args['intro_text'] = sprintf('<p>感谢使用萨龙网络原创主题<strong>' . $xzv_3->display('Name') . '</strong>，更多主题请访问：<a href="https://salongweb.com/shop.html" target="_blank">主题商城</a>，技术支持：<a href="https://salongweb.com/contact.html" target="_blank">联系我们</a></p>');
            }
        }
    }
    global $reduxConfig;
    $reduxConfig = new Redux_Framework_sample_config();
}